import { Component, OnInit } from '@angular/core';
import { MessageService } from 'primeng/components/common/messageservice'



@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})

export class NewComponent implements OnInit {

 value: number = 0;
 msgs: MessageService[];

  constructor(private messageService: MessageService) { }

  alertSuccess(){
    this.messageService.add([{severity: 'success', summary: 'Success', detail: 'Success Message'}]);
  }

  ngOnInit() {

  let interval = setInterval(() => {
             this.value = this.value + Math.floor(Math.random() * 10) + 1;
             if(this.value >= 100) {
                 this.value = 100;
                 //this.msgs = [severity: 'success', summary: 'Success', detail: 'Process Completed'];
                 clearInterval(interval);
             }
         }, 2000);
     }

  testMessage() {
    this.messageService.addAll([
      {severity: 'success', summary: 'Success status', detail: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.'},
      {severity: 'warn', summary: 'Warning status', detail: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.'},
      {severity: 'error', summary: 'Error status', detail: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.'},
      {severity: 'info', summary: 'Info status', detail: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.'}
    ])

  }


// accordionTab
index: number = -1;

    openNext() {
        this.index = (this.index === 3) ? 0 : this.index + 1;
    }

    openPrev() {
        this.index = (this.index === 0) ? 3 : this.index - 1;
    }



    onTabOpen(e) {
        var index = e.index;
    }


}
