import {Injectable} from '@angular/core';
import {Headers, Http, Response} from '@angular/http';
import {Observable} from 'rxjs/Rx'
import {environment} from '../../../environments/environment'
import {Menu} from './menu';

@Injectable()
export class MenusService {
  private _menus: Observable<any>
  private headers = new Headers({'X-UserId': 'user01', 'X-Key': '12345'})
  private menuGUID
  private coreAPI
  private MENUS_URL = '../../assets/config/menus.json'

  constructor(private http: Http) {}

  public clearCache(): any {
    // super.clearCache();
    this._menus = null;
  }

  public getMenus(): Observable<Menu[]> {
    return this._getMenus()
  }

  private _getMenus(): Observable<Menu[]> {
    if (!this._menus) {
      let url = (environment.use_backend) ? `${environment.coreAPI}/menus` : this.MENUS_URL
      this._menus =
        this.http.get(url, {headers: this.headers})
          .map((res) => this.mapMenu(res))
          .publishReplay(1)
          .refCount()
          .catch((err, caught) => this.handleError(err))
    }
    return this._menus;
  }

  public setMenus(menus: Menu[]) {
    return this._setMenus(menus)
  }

  private _setMenus(menus: Menu[]): Observable<boolean> {

    return this.http.put(`${environment.coreAPI}/menus/${this.menuGUID}`, menus, {headers: this.headers})
      .map(response => {
        console.log(response)
        return response.text()
      })
      .catch(this.handleError)
  }

  private mapMenu(response: Response): Menu[] {
    // TODO we are using the first menu item, will need to map user.group.menu.id
    let item0 = response.json().items[0];
    this.menuGUID = item0.id;
    return item0.item.map(this.toMenu);
  }

  private toMenu(r: any): Menu {
    const menu = <Menu>({
      title: r.title,
      uri: r.uri,
      subMenu: r.subMenu
    });
    return menu;
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }
}
