import {Injectable} from '@angular/core'
import {Headers, Http, Response} from '@angular/http'
import {Observable} from 'rxjs/Rx'
import {MainContent} from './maincontent'
import {Product} from './product'
import {ProductLink} from './product-link'
import {environment} from "../../../environments/environment";

@Injectable()
export class MainContentService {
  private productName: string;
  private _maincontent: Observable<any>
  private _product: Observable<any>
  private headers = new Headers({'X-UserId': 'user01', 'X-Key': '12345'})
  private mainContentGUID
  private coreAPI
  private MAIN_CONTENT_URL = '../../assets/config/maincontent.json'

  constructor(private http: Http) {
    console.log('MainContentService cTor')
  }

  public getContent(): Observable<MainContent> {
    return this._getContent()
  }

  private _getContent(): Observable<MainContent> {
    if (!this._maincontent) {
      let url = (environment.use_backend) ? `${environment.coreAPI}/maincontent` : this.MAIN_CONTENT_URL
      this._maincontent =
        this.http.get(url, {headers: this.headers})
          .map((res) => this.mapMainContent(res))
          .catch((err, caught) => this.handleError(err))
    }
    return this._maincontent;
  }

  public saveContent(mainContent: MainContent) {
    return this._saveContent(mainContent)
  }

  private _saveContent(mainContent: MainContent): Observable<boolean> {
    return this.http.put(`${environment.coreAPI}/maincontent/${this.mainContentGUID}`, mainContent, {headers: this.headers})
      .map(response => {
        console.log(response)
        return response.text()
      })
      .catch(this.handleError)
  }

  public getProduct(productName: string): Observable<Product> {
    this.productName = productName;
    return this._getProduct()
  }

  private _getProduct(): Observable<Product> {
    if (!this._product) {
      let url = (environment.use_backend) ? `${environment.coreAPI}/maincontent` : this.MAIN_CONTENT_URL
      this._product =
        this.http.get(url, {headers: this.headers})
          .map((res) => this.mapProduct(res))
          .catch((err, caught) => this.handleError(err))
    }
    return this._product;
  }

  private mapProduct(res: Response): Product {
    let result = res.json().items[0].item
    let products: Array<Product> = result["product"]

    for (let i = 0; i < products.length; i++) {
      if (this.productName === products[i].name.toLowerCase()) {

        let prod: Product = new Product()
        prod.name = products[i].name
        prod.erevenueUrl = products[i].erevenueUrl

        let links = products[i].links
        if (links) {
          for (let j = 0; j < links.length; j++) {
            let link: ProductLink = new ProductLink()
            link.name = links[j].name
            link.uri = links[j].uri
            prod.links.push(link)
          }
        }
        return prod
      }
    }
    return null
  }

  private mapMainContent(res: Response): MainContent {
    let item0 = res.json().items[0]
    this.mainContentGUID = item0.id
    let response = item0.item
    let mainContent = new MainContent()
    let products: Array<Product> = response["product"]

    for (let i = 0; i < products.length; i++) {
      let prod: Product = new Product()

      prod.name = products[i].name
      prod.erevenueUrl = products[i].erevenueUrl

      let links = products[i].links
      if (links) {
        for (let j = 0; j < links.length; j++) {
          let link: ProductLink = new ProductLink()
          link.name = links[j].name
          link.uri = links[j].uri
          prod.links.push(link)
        }
      }
      mainContent.product.push(prod)
    }

    mainContent.phone = response["phone"]
    mainContent.emailText = response["emailText"]
    mainContent.emailValue = response["emailValue"]
    mainContent.helpContent = response["helpContent"]

    return mainContent
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }

}
