import {inject, TestBed} from '@angular/core/testing'
import {MockBackend, MockConnection} from '@angular/http/testing'
import {BaseRequestOptions, Http, Response, ResponseOptions} from '@angular/http'

import {MainContentService} from './maincontent.service'
import {MainContent} from './maincontent'

describe('MainContentService', function () {
  let subject: MainContentService
  let backend: MockBackend

  beforeEach(function () {

    TestBed.configureTestingModule({
      providers: [
        MainContentService,
        MockBackend,
        BaseRequestOptions,
        {
          provide: Http,
          useFactory: function (mockBackend, defaultOptions) {
            return new Http(mockBackend, defaultOptions);
          },
          deps: [MockBackend, BaseRequestOptions]
        }
      ]
    })

  })

  beforeEach(inject([MainContentService, MockBackend], function (mainContentService, mockBackend) {
    subject = mainContentService
    backend = mockBackend
  }))

 it('should get data', function (done) {

    backend.connections.subscribe(function (connection: MockConnection) {

      let options = new ResponseOptions({
        body: {
          "items": [
            {
              "collection": "maincontent",
              "id": "default_maincontent",
              "item": {
                "product": [
                  {
                    "name": "home",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/Home.aspx"
                  },
                  {
                    "name": "eBilling",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=eBilling"
                  },
                  {
                    "name": "eInsurance",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=eInsurance"
                  },
                  {
                    "name": "ePharmacy",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=ePharmacy"
                  },
                  {
                    "name": "ePayments",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=ePayments"
                  },
                  {
                    "name": "NPI",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=NPI"
                  },
                  {
                    "name": "Non-MCCF",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=TricareChampva"
                  },
                  {
                    "name": "eAdmin",
                    "erevenueUrl": "https://URL/sites/eBusinessSolutions/SitePages/Home.aspx"
                  }
                ],
                "phone": "(800) 555-5555",
                "emailText": "PII             ",
                "emailValue": "PII             ",
                "helpContent": "help line 1<br> help line2<br> <p>dial <b>9-1-1</b> for an emergency</p><br><I>Thank you!</I>"
              }
            }
          ],
          "total": 1
        }
      })
      connection.mockRespond(new Response(options))
    })

    subject.getContent().subscribe(function (response) {
        expect(response).toEqual(jasmine.any(MainContent))
        expect(response.product.length).toEqual(8)
        expect(response.product[0].name).toEqual('home')
      },
      function (e) {
        fail(e);
      }
    );

    done()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  })

})
