export class LocalConfig {
    static get ApiServer(): string {
        // return "http://mccf.local:8193"
        return "http://localhost:8193"
    }
    static _dataProvider: string
    static get DataProvider(): string {
        // return LocalConfig._dataProvider || "http"
        return LocalConfig._dataProvider || "memory"
        // return LocalConfig._dataProvider || "LocalStorage"
    }
    static set DataProvider(value: string) {
        LocalConfig._dataProvider = value
    }
    static get UseConfigApiService(): boolean {
        return true
    }
    static get EnableApiLogging(): boolean {
        return true
    }
    static get Defaults(): any {
        return {
            LogLevel: "Info",
            SecondsForExternalRedirect: 20,
            LocalDomains: [0, 1, 2, 3, 4, 5, 6].map(p => 'http://localhost:420' + p)
        }
    }
}
