import { TestBed, inject } from '@angular/core/testing'

import { HttpModule, Http, BaseRequestOptions, XHRBackend } from '@angular/http';
import { MockBackend } from '@angular/http/testing';

import { LocalConfig } from './local-config'
import { Config, ConfigService } from './config.service'
import { ConfigApiService } from './config-api.service'
import {ErrorService} from "../error-messages/error.service";

describe('ConfigService', () => {
    beforeEach(() => {
        LocalConfig.DataProvider = "memory"
        TestBed.configureTestingModule({
            imports: [HttpModule],
            providers: [{
                provide: Http, useFactory: (backend, options) => {
                    return new Http(backend, options);
                },
                deps: [MockBackend, BaseRequestOptions]
            },
                MockBackend,
                BaseRequestOptions,
                ConfigService,
                ConfigApiService,
                ErrorService
            ]
        })
    })

    afterEach(function () {
        TestBed.resetTestingModule()
    })

    it('expects value of _TestNumericValue', inject([ConfigService, ConfigApiService], async (service: ConfigService, configApiService: ConfigApiService) => {
        expect(await service.load(Config._TestNumericValue)).toEqual(42)
    }))

    it('expects value of _TestArrayValue (array)', inject([ConfigService, ConfigApiService], async (service: ConfigService, configApiService: ConfigApiService) => {
        expect(await service.load(Config._TestArrayValue)).toEqual([1, 2, 3, 4])
        expect(await service.load(Config._TestArrayValue)).not.toEqual([1, 2, 2, 4])
    }))
})
