import { Component, OnInit } from '@angular/core';

import { Day } from './day'

@Component({
  selector: 'app-tas-calendar',
  templateUrl: './calendar.component.html',
  styleUrls: ['./calendar.component.css']
})

// barebones calendar that is 508 accessibility compliant
export class CalendarComponent implements OnInit {
  days: Array<Day> = []
  rows = [0, 7, 14, 21, 28, 35]
  columns = [0, 1, 2, 3, 4, 5, 6]
  monthNames = ["January", "February", "March", "April", "May", "June",
   "July", "August", "September", "October", "November", "December"]
  selected: Date
  calTitle = ""

  constructor() { }

  ngOnInit() {
      let now = new Date()
      let cur = new Date(now.getFullYear(), now.getMonth())
      this.updateDays(cur)
  }

  updateDays(d: Date) {
    this.days = []
    this.selected = d
    this.calTitle = this.monthNames[d.getMonth()] + ' ' + d.getFullYear()

    let firstDay = d.getDay()
    let daysInCurMonth = new Date(d.getFullYear(), (d.getMonth() + 1), 0).getDate()
    let prevDays = 42 - firstDay
    let latterDays = 42 - firstDay - daysInCurMonth

    let prev: Date
    if (d.getMonth() === 0) {
        prev = new Date(d.getFullYear() - 1, 11, 1);
    } else {
        prev = new Date(d.getFullYear(), d.getMonth() - 1, 1);
    }

    let prevLastDay = new Date(prev.getFullYear(), (prev.getMonth() + 1), 0).getDate()

    for (let p = prevLastDay - firstDay; p < prevLastDay; p++ ) {
      let day = new Day()
      day.number = p + 1
      day.current = false
      this.days.push(day)
    }

    for (let i = 0; i < daysInCurMonth; i++) {
      let day = new Day()
      day.number = i + 1
      day.current = true

      let now = new Date()
      if (now.getFullYear() === d.getFullYear()
        && now.getMonth() === d.getMonth()
        && day.number === now.getDate()) {
          day.today = true
      }

      this.days.push(day)
    }

    for (let a = 0; a < latterDays; a++) {
      let day = new Day()
      day.number = a + 1
      day.current = false
      this.days.push(day)
    }
  }

  prevMonth() {
    let prev: Date

    if (this.selected.getMonth() === 0) {
        prev = new Date(this.selected.getFullYear() - 1, 11, 1);
    } else {
        prev = new Date(this.selected.getFullYear(), this.selected.getMonth() - 1, 1);
    }

    this.updateDays(prev)
  }

  nextMonth() {
    let next: Date

    if (this.selected.getMonth() === 11) {
        next = new Date(this.selected.getFullYear() + 1, 0, 1);
    } else {
        next = new Date(this.selected.getFullYear(), this.selected.getMonth() + 1, 1);
    }

    this.updateDays(next)
  }

}
