import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  getTestBed,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { CalendarComponent } from './calendar.component'

describe('CalendarComponent', () => {
  let component: CalendarComponent
  let fixture: ComponentFixture<CalendarComponent>
  let originalTimeout

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [],
      declarations: [
        CalendarComponent
      ],
      providers: []
    })

  }))

  beforeEach(async(() => {
    TestBed.compileComponents()
  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(CalendarComponent)
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function() {
    TestBed.resetTestingModule()
  });

  it('should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    fixture.detectChanges()
    tick()

    // console.error(' @@@@@@@@@@@@@ html=' + document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))
})
