import { Injectable } from '@angular/core'
import { environment } from '../../../environments/environment'
import { AppInsights } from 'applicationinsights-js'

@Injectable()
export class MonitoringService {

  private config: Microsoft.ApplicationInsights.IConfig = {
    instrumentationKey: environment.appInsights.instrumentationKey
  }

  constructor() {
    if (!environment.appsInsightsOn) {
      console.log("APPLICATION INSIGHTS: OFF")
      return
    }

    if (!AppInsights.config) {
      console.log("APPLICATION INSIGHTS: STARTED")
      AppInsights.downloadAndSetup(this.config)
    }
  }

  logPageView(name?: string, url?: string, properties?: any,
              measurements?: any, duration?: number) {
    if (!environment.appsInsightsOn) { return }
    AppInsights.trackPageView(name, url, properties, measurements, duration)
  }

  logEvent(name: string, properties?: any, measurements?: any) {
    if (!environment.appsInsightsOn) { return }
    AppInsights.trackEvent(name, properties, measurements)
  }

  logHttpCall(measurement: number) {
    if (!environment.appsInsightsOn) { return }
    AppInsights.trackMetric('Server response time', measurement)
  }

}
