import { Injectable } from '@angular/core'
import { Subject }    from 'rxjs/Subject'

@Injectable()
export class AppCommService {

  // Observable string sources
  private linkNoticeSource = new Subject<string>()

  // Observable string streams
  linkNotice$ = this.linkNoticeSource.asObservable()

  // Service message commands
  linkNoticeOpen(linkId: string) {
    this.linkNoticeSource.next(linkId)
  }

}
