import { BrowserModule } from '@angular/platform-browser';
import { NoopAnimationsModule } from '@angular/platform-browser/animations'
import { GrowlModule } from 'primeng/primeng'
import { ScheduleModule } from 'primeng/primeng'
import { NgModule, ErrorHandler } from '@angular/core'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import { HttpModule, Http } from '@angular/http';

import { AppComponent } from './app.component'

import { routing } from './app.routing'
import { HomepageComponent } from './core/homepage/homepage.component'
import { NotFoundComponent } from './core/not-found/not-found.component'
import { ErrorModalComponent } from './core/error-messages/error-modal/error-modal.component'
import { ErrorService } from './core/error-messages/error.service'
import { ClipboardModule } from 'ngx-clipboard'

import { GlobalErrorHandler } from './global.error-handler'
import { ConfigService } from './core/config/config.service'
import { ActiveState } from './core/activestate/activestate.service'
import { LoggerService } from './core/logger/logger.service';
import { AppCommService } from './core/app-comm/app-comm.service';
import { LoggingApiService } from './core/logger/logging-api.service';
import { ConfigApiService } from './core/config/config-api.service';
import { SearchApiService } from './core/search/search-api.service';
import { MccfCommonModule } from './mccf-common/mccf-common.module'
import { MccfSearchModule } from './mccf-search/mccf-search.module'
import { MccfSystemModule } from './mccf-system/mccf-system.module'
import { SearchComponent } from './core/search/search.component'
import { TasHttp } from './core/tasHttp/tas-http.service'
import { MenusService} from "./core/menus/menus.service";
import { TooltipsService} from "./mccf-common/tooltips/tooltips.service";
import { MonitoringService} from "./core/application-insights/monitoring.service";
import { MainContentService} from "./core/maincontent/maincontent.service";
import { MessageService} from "primeng/components/common/messageservice";
import { SeedService} from "./core/seed/seed.service"
import { IamRecordService} from "./mccf-system/service/iam.service";
import { NewComponent } from './core/new/new.component';
import { ProgressBarModule} from 'primeng/primeng';
import { CalendarComponent } from './core/calendar/calendar.component';
import { AccordionModule} from 'primeng/primeng';
import { TabViewModule} from 'primeng/primeng';
import {CodeHighlighterModule} from 'primeng/components/codehighlighter/codehighlighter';


@NgModule({
  declarations: [
    AppComponent,
    HomepageComponent,
    NotFoundComponent,
    ErrorModalComponent,
    SearchComponent,
    NewComponent,
    CalendarComponent
  ],
  imports: [
    BrowserModule,
    NoopAnimationsModule,
    GrowlModule,
    ScheduleModule,
    FormsModule,
    ReactiveFormsModule,
    ClipboardModule,
    HttpModule,
    routing,
    MccfCommonModule,
    MccfSearchModule,
    MccfSystemModule,
    ProgressBarModule,
    AccordionModule

  ],
  providers: [
    ErrorService,
    MenusService,
    IamRecordService,
    SeedService,
    TooltipsService,
    MonitoringService,
    MainContentService,
    MessageService,
    ConfigService,
    ConfigApiService,
    LoggerService,
    LoggingApiService,
    SearchApiService,
    ActiveState,
    AppCommService,
    { provide: ErrorHandler, useClass: GlobalErrorHandler },
    { provide: Http, useClass: TasHttp }
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
