import {Component, OnInit, ViewEncapsulation} from '@angular/core'
import {Router, NavigationEnd} from '@angular/router'
import {Title} from '@angular/platform-browser'
import {MenusService} from './core/menus/menus.service'
import {MainContentService} from './core/maincontent/maincontent.service'
import {Menu} from './core/menus/menu'
import {MainContent} from './core/maincontent/maincontent'
import {ErrorService} from './core/error-messages/error.service'
import {ErrorMessage} from './core/error-messages/error-message'
import {FormControl, FormGroup, Validators} from '@angular/forms';

import {LocalConfig} from './core/config/local-config'
import {Config, ConfigService} from './core/config/config.service'
import {BrowserConsoleOutputProvider, ILogMessage, LoggerService, LogLevel} from './core/logger/logger.service'

import {LoggingApiService} from './core/logger/logging-api.service'
import {Data} from './core/database/data'
import {MemoryDbVariableMode} from './core/database/memorydb'
import {SeedService} from "./core/seed/seed.service";
import {MessageService} from "primeng/components/common/messageservice";

const TITLE = 'eBusiness Solutions'
const COMMON_URL = 'common'

@Component({
  selector: 'app-root',
  encapsulation: ViewEncapsulation.None,
  styleUrls: [
    '../assets/css/tas-custom.css',
    '../assets/uswds/css/uswds.css',
    './app.component.css',
    '../assets/font-awesome-4.7.0/css/font-awesome.css',
    '../assets/primeng/resources/themes/tas-core/theme.css',
    '../assets/primeng/resources/primeng.min.css',
    '../assets/css/fullcalendar.css',
    '../assets/css/quill.snow.css'
  ],
  templateUrl: './app.component.html'
})

export class AppComponent implements OnInit {
  searchGroup: FormGroup

  search: string
  product = 'home'
  productLink = '?'
  maincontentService: MainContentService
  messageService: MessageService
  errorMessage = ''
  appError: ErrorMessage
  menus: Menu[]
  maincontent: MainContent
  _data: Data

  constructor(private menuService: MenusService,
              private errorService: ErrorService,
              private router: Router,
              private titleService: Title,
              private loggingApiService: LoggingApiService,
              private loggerService: LoggerService,
              private seedService: SeedService,
              private configService: ConfigService,
              private mcService: MainContentService,
              private messService: MessageService) {
    // TODO this.messageService = messService is not being used, why is this here DJH 11/2?
    this.messageService = messService
    this.maincontentService = mcService
    this._data = new Data(new MemoryDbVariableMode())
    errorService.errorCode$.subscribe(newErr => this.appError = newErr);
    console.log("AppComponent::.ctor")

    for (let seed of this.seedService.seeds) {
      this.seedService.getSeed(seed.collection, seed.jsonURL).subscribe(
        res => {
          console.log(`getSeed() ${seed.collection} Success ` + res)
        },
        err => {
          console.log(`getSeed() ${seed.collection} Failure, it's ok ` + err)
        })
    }

    // N.B. logging does it's own seeding
    this.configService.setDefaults()
      .then(async () => {
        const logLevel = await this.configService.load(Config.LogLevel)
        // console.log(`>>>>>>>>>>>>>>>>>>>>>>>logLevel:${logLevel}`)
        this.loggerService.setlogLevel(LogLevel[<string>logLevel])
        this.router.events.subscribe((val) => {
          this.loggerService.info(val.toString())
        })

        const enableApiLogging = LocalConfig.EnableApiLogging
        if (enableApiLogging) {
          console.log('Logging is on')
          this.loggerService.setOutputProvider((data: ILogMessage): void => {
            BrowserConsoleOutputProvider(data)
            this.loggingApiService.add(data.level.toString(), data.message)
              .subscribe(id => {
                console.log('loggingApiService::add called|id:' + id)
                let options = {page: 1, pageSize: 4}
                options['text'] = 'urlAfterRedirects'
                this.loggingApiService.get(options)
                  .subscribe(logData => {
                    console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}`)
                  })
              })
          })
        } else {
          this.loggerService.setOutputProvider(BrowserConsoleOutputProvider)
        }
      })
  }

  ngOnInit() {

    // update title in browser tab
    this.router.events.subscribe((event) => {
      if (event instanceof NavigationEnd) {

        this.returnTop()

        let page = event.urlAfterRedirects
                      .replace(COMMON_URL, "")
                      .split("/")
                      .join(" ")
                      .trim()

        // dont show search params
        if (page.indexOf('?') > 0) {
          page = page.substring(0, page.indexOf('?'))
        }

        this.titleService.setTitle(TITLE + " " + page)
      }
    })

    // TODO user a resolver; how do we want to handle error - this would be a good place to fail
    // this.menuService.getMenus().subscribe(this.menuUpdate.bind(this))
    this.menuService.getMenus().subscribe(
      res => {
        this.menuUpdate(res);
      }
      ,
      err => {
        this.errorService.setErrorCode("", err)
      }
    )
    this.maincontentService.getContent().subscribe(this.contentUpdate.bind(this))

    this.searchGroup = new FormGroup({
      searchVal: new FormControl('', Validators.required)
    })
  }

  isRouteLink(sub) {

    if (typeof sub.uri === 'undefined') {
      return false
    }
    if (sub.uri.startsWith('/') === true) {
      return true
    }
    if (typeof sub.isRouteLink !== 'undefined' && sub.isRouteLink === true) {
      return true
    }
    if (sub.uri.indexOf('http:') === -1 && sub.uri.indexOf('https:') === -1) {
      return true
    }
    return false
  }

  menuUpdate(data: any) {
    this.menus = data;
  }

  contentUpdate(data: any) {
    this.maincontent = data;
    this.setProductLink('home')
  }

  onSearchSubmit() {
    //    console.log("@@@ ="+JSON.stringify(value))
    // TODO get validation working
    if (this.search) {
      this.router.navigate(['/search/' + this.search])
    }
  }

  setProductLink(uri) {
    let prod = uri.split('/')
    if (this.maincontent) {
      for (let i = 0; i < this.maincontent.product.length; i++) {
        if (this.maincontent.product[i].name.toLowerCase() === prod[0].toLowerCase()) {
          this.productLink = this.maincontent.product[i].erevenueUrl
          return
        }
      }
      this.productLink = this.maincontent.product[0].erevenueUrl
    } else {
      this.productLink = ''
    }
  }

  onSaveChange(value) {
    console.log("onSaveValue =" + value)
    this.search = value
    // TODO get validation working
    //    this.router.navigate(['/search/'+l])
  }

  returnTop() {
    window.scrollTo(0, 0)
  }

}
