#!/bin/sh
my_scriptname=$(basename "$0")
start=`date +%s`
echo "$my_scriptname: start time $start"
echo "$my_scriptname: Setup environment for scanning"
divider="====== ========== ========== ========== ========== ========== ========== ======"
echo "$divider"
echo "$my_scriptname: Remove previous scans"
rm -f *fortify_scan.*

scanid="TASCore"
WorkingDirectory="working"
buildID="${BUILD_NUMBER}"

log="$WorkingDirectory/sca.log"

source='dist'
fortifyHome="/opt/fortify"

BITRReportTemplate="Developer Workbook"
RGReportTemplate="DeveloperWorkbook.xml"

if [[ -z $buildID ]]
then
  fprFilename="${scanid}_fortify_scan.fpr"
  BITRReportName="${scanid}_BITR_Report.pdf"
  RGReportName="${scanid}_standard_report.pdf"
else 
  fprFilename="${scanid}_${buildID}_fortify_scan.fpr"
  BITRReportName="${scanid}_${buildID}_BITR_Report.pdf"
  RGReportName="${scanid}_${buildID}_standard_report.pdf"
fi

analyzer_cmd="$fortifyHome/bin/sourceanalyzer -64 -Xmx1300M"
analyzer_args="-Dcom.fortify.sca.ProjectRoot=$WorkingDirectory -Dcom.fortify.WorkingDirectory=$WorkingDirectory -Dcom.fortify.sca.EnableDOMModeling=true -Dcom.fortify.sca.hoa.Enable=true -logfile $log"

if [[ -d $WorkingDirectory ]]
then
  rm -rf $WorkingDirectory
fi

mkdir -p $WorkingDirectory

echo "$divider"
echo "$my_scriptname: Step 1 Remove all existing Fortify Static Code Analyzer temporary files"
#Remove all existing Fortify Static Code Analyzer temporary files for the specified build ID. Always
#begin an analysis with this step to analyze a project with a previously used build ID.
#example:
#$fortifyHome/bin/sourceanalyzer -64 -b $scanid -Xmx1300M -clean
$analyzer_cmd $analyzer_args -b $scanid -clean

echo "$divider"
echo "$my_scriptname: Step 2 Translate the project code for $scanid"
#This step can consist of multiple calls to sourceanalyzer with the same
#build ID.

$analyzer_cmd -b $scanid $analyzer_args "$source" -verbose -debug-verbose

echo "$divider"
echo "$my_scriptname: show-build-warnings"
$analyzer_cmd -b $scanid $analyzer_args -show-build-warnings -verbose -debug

echo "$divider"
echo "$my_scriptname: show-files"
$analyzer_cmd -b $scanid $analyzer_args -show-files -verbose -debug

echo "$divider"
echo "$my_scriptname: Step 3 Analyze the project code and produce the results file (${fprFilename})"
$analyzer_cmd -b $scanid $analyzer_args -scan -format fpr -f $fprFilename -verbose -debug

echo "$divider"
echo "$my_scriptname: Step 4 Generate Report ($RGReportName) from analysis"
#$fortifyHome/bin/BIRTReportGenerator -Dcom.fortify.sca.ProjectRoot=$WorkingDirectory -Dcom.fortify.WorkingDirectory=$WorkingDirectory -template "$BITRReportTemplate" -source $fprFilename -output $BITRReportName -format "PDF" -showSuppressed -showHidden -showRemoved --UseFortifyPriorityOrder -verbose -debug
$fortifyHome/bin/ReportGenerator -Dcom.fortify.sca.ProjectRoot=$WorkingDirectory -Dcom.fortify.WorkingDirectory=$WorkingDirectory -template "$RGReportTemplate" -format "pdf" -f $RGReportName -source $fprFilename -showSuppressed -showHidden -showRemoved -verbose -debug

echo "$divider"

end=`date +%s`
runtime=$(($end-$start))
echo "$my_scriptname: START:$start END:${end} ELAPSED: $((($end-$start)/60)) minutes"
echo "$my_scriptname: END scan and report generation ELAPSED ${runtime} seconds"
echo "$divider"
echo "$divider"
