// Protractor configuration file, see link for more information
// https://github.com/angular/protractor/blob/master/lib/config.ts

const Jasmine2HtmlReporter = require('protractor-jasmine2-html-reporter');
const { SpecReporter } = require('jasmine-spec-reporter');
const JUnitReporter =  require('./e2e/src/loggers/junitreporter');


exports.config = {
  allScriptsTimeout: 30000,
  getPageTimeout: 30000,
  // Default
  suite: 'daily',

  // Tests to run
  suites: {
    // Run all User Story Test Cases
    // regression: ['./e2e/src/us/*.e2e.ts'],

    // Dev is used to run a small number of tests in your local environment
    dev: ['./e2e/src/helpers/dev.e2e.ts'],

    // Performance tests
    perf: ['./e2e/src/performance/*.ts'],

    // Daily build tests
    daily: ['./e2e/src/us/us*.e2e.ts']
  },
  
  // Browser settings
  capabilities: {
    // PhantomJS
    'browserName': 'phantomjs',
    //Can be used to specify the phantomjs binary path.
    'phantomjs.binary.path': require('phantomjs-prebuilt').path,
    'phantomjs.cli.args': ['--ignore-ssl-errors=true', '--web-security=false']
    //version: '',
    //platform: 'ANY'

    // Chrome
    //'browserName': 'chrome',
    //chromeOptions: {
    //  args: ['--no-sandbox', '--ignore-certificate-errors'],
    //},
  },
  //seleniumAddress: 'http://localhost:4444',
  seleniumPort: 55056,
  seleniumServerJar: './e2e/selenium/selenium-server-standalone-3.4.0.jar',
  //chromeDriver: './e2e/selenium/drivers/chromedriver_2.31.exe',
  //directConnect: true,
  baseUrl: 'http://localhost:4200/',
  //baseUrl: 'https://aws-app.mccf.halfakerlabs.com',
  framework: 'jasmine',

  jasmineNodeOpts: {  // ----- Options to be passed to minijasminenode
      // onComplete will be called just before the driver quits.
      onComplete: null,
      // If true, display spec names.
      isVerbose: false,
      // If true, print colors to the terminal.
      showColors: true,
      // If true, include stack traces in failures.
      includeStackTrace: true,
      // Default time to wait in ms before a test fails.
      defaultTimeoutInterval: 1200000   //Set this really high for data-driven tests and let Protractor/WebDriver fail an inactive test run.
  },

  // Before running any tests, this is called
  onPrepare() {
    require('ts-node').register({
      project: 'e2e/tsconfig.e2e.json'
    });
    
    // Set browser size
    browser.driver.manage().window().setSize(1024, 768);

    

	 // Add a reporter and store screenshots to `screnshots`:
   /*
    jasmine.getEnv().addReporter(new Jasmine2HtmlReporter({
      savePath: './e2e/reports/',
      screenshotsFolder: 'screenshots',
      takeScreenshots: true,
      takeScreenshotsOnlyOnFailures: false,
      fixedScreenshotName: false,
      fileNamePrefix: '',
      fileName: 'test-report',
      fileNameSuffix: '',
      fileNameSeparator: '_',
      fileNameDateSuffix: false,
      consolidate: true,
      consolidateAll: true,
      cleanDestination: true,
      showPassed: true
    }));
    */

    // Stacktrace reporter  
    
    jasmine.getEnv().addReporter(new SpecReporter({
      spec: {
        displayStacktrace: true
      }
    }));
    
    // Custom JUnit reporter
    jasmine.getEnv().addReporter( new JUnitReporter({saveFilename: 'testresults.xml', savePath: './e2e/logs'}) );
    
  }
};
