//us3581.compliance.e2e.ts
import 'jasmine';
import {browser, by} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';
var AxeBuilder = require('axe-webdriverjs');
var pages = new Pages();
var helpers = new Helpers();

describe('US3581 Review New v2.0 508 compliance user stories', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });

  it('TC2053 Verify the Calendar Next Button only uses allowed ARIA attributes', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2054 Verify the Calendar Previous Button only uses allowed ARIA attributes', function() {
    AxeBuilder(browser).include(pages.home.css_previous).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2055 Verify the Calendar Previous Button only uses appropriate ARIA attributes describing the state or properties', function() {
    AxeBuilder(browser).include(pages.home.css_previous).withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2058 Verify the Calendar Next Button only uses appropriate ARIA attributes describing the state or properties', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2061 Verify the Calendar Next Button has required ARIA parent roles', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('aria-required-parent').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2062 Verify the Calendar Previous Button has required ARIA parent roles', function() {
    AxeBuilder(browser).include(pages.home.css_previous).withRules('aria-required-parent').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2063 Verify the Calendar Previous Button has ARIA role is valid', function() {
    AxeBuilder(browser).include(pages.home.css_previous).withRules('aria-roles').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2064 Verify the Calendar Next Button has ARIA role is valid', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('aria-roles').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2065 Verify the Calendar Next Button Aria attributes values are valid', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2066 Verify the Calendar Previous Button Aria attributes values are valid', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2067 Verify the Calendar Previous Button ARIA attribute names must be valid', function() {
    AxeBuilder(browser).include(pages.home.css_previous).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2068 Verify the Calendar Next Button ARIA attribute names must be valid', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2069 Verify the Calendar Next Button has a discernible, accessible name', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2070 Verify the Calendar Previous Button has a discernible, accessible name', function() {
    AxeBuilder(browser).include(pages.home.css_previous).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2071 Verify the Calendar Previous Button has a discernible, accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_eBusinessSolutions).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2072 Verify the eInsurance footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_eInsurance).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2096 Verify the ePharmacy footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_ePharmacy).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2098 Verify the ePayments footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_ePayments).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2099 Verify the non-mccf footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_nonmccf).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2100 Verify the NPI footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_npi).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2101 Verify the eAdmin footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_eAdmin).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2106 Verify the TAS playbook footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_TAS_Playbook).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2109 Verify the TAS Design Guide footer link has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_TAS_Design_Guide).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2110 Verify the Date Time Clock in footer has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_dateTime).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2111 Verify the Provide Feedback link in footer has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_provide_feedback).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2112 Verify the email link in footer has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.footer.css_email).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2113 Verify the email link in footer has sufficient color contrast', function() {
    AxeBuilder(browser).include(pages.home.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2114 Verify the Return to Top link on the eInsurance Page has sufficient color contrast', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.eInsurance.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2115 Verify the Return to Top link on the ePharmacy Page has sufficient color contrast', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.ePharmacy.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2116 Verify the Return to Top link on the eBilling Page has sufficient color contrast', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.eBilling.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2118 Verify the Return to Top link on the ePayments Page has sufficient color contrast', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.ePayments.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2124 Verify the Return to Top link on the Non-MCCF Page has sufficient color contrast', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.nonMCCF.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2125 Verify the Return to Top link on the NPI Page has sufficient color contrast', function() {
    pages.menuNav.npi.click();
    expect(pages.npi.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.npi.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2126 Verify the Return to Top link on the eAdmin Page has sufficient color contrast', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.eAdmin.css_return_to_top_link).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2127 Verify the eBusiness Solutions footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_eBusinessSolutions).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2128 Verify the eInsurance footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_eInsurance).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2129 Verify the ePharmacy footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_ePharmacy).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2130 Verify the ePayments footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_ePayments).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2131 Verify the Non-MCCF footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_nonmccf).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2132 Verify the NPI footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_npi).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2133 Verify the eAdmin footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_eAdmin).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2140 Verify the TAS Playbook footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_TAS_Playbook).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2141 Verify the TAS Design Guide footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_TAS_Design_Guide).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2142 Verify the email footer link has an accessible name', function() {
    AxeBuilder(browser).include(pages.footer.css_email).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2143 Footer VA Logo has alternative text, role="presentation" or role="none"', function() {
    AxeBuilder(browser).include(pages.footer.css_va_logo).withRules('image-alt').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

});