//us3009.compliance.e2e.ts
import 'jasmine';
import {browser, by} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';
var AxeBuilder = require('axe-webdriverjs');
var pages = new Pages();
var helpers = new Helpers();

describe('US3009 (Copy of) 508.01.01.04 Software Application User Interface Elements (1194.21D)', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });

   it('TC1419 Verify the document\'s nav tag\'s (i.e., <nav>) ARIA role contains all required child roles.', function() {
    AxeBuilder(browser).include('nav').withRules('aria-required-children').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1420 Verify the document\'s div _ngcontent-c2 element\'s (i.e., <div _ngcontent-c2>) ARIA role contains all required child roles.', function() {
    AxeBuilder(browser).include('div').withRules('aria-required-children').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1421 Verify the document\'s footer tag\'s (i.e., <footer>) ARIA role contains all required child roles.', function() {
    AxeBuilder(browser).include('footer').withRules('aria-required-children').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1426 Verify the document\'s header tag\'s (i.e., <header>) ARIA role conforms to a valid value(s).', function() {
    AxeBuilder(browser).include('header').withRules('aria-roles').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1427 Verify the document\'s nav tag\'s (i.e., <nav>) ARIA role conforms to a valid value(s).', function() {
    AxeBuilder(browser).include('nav').withRules('aria-roles').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1428 Verify the document\'s div _ngcontent-c2 element\'s (i.e., <div _ngcontent-c2=>) ARIA role conforms to a valid value(s).', function() {
    AxeBuilder(browser).include('div').withRules('aria-roles').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1429 Verify the document\'s footer tag\'s (i.e., <footer>) ARIA role conforms to a valid value(s).', function() {
    AxeBuilder(browser).include('footer').withRules('aria-roles').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1430 Verify, for the "Here\'s how you know" button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.usaBanner.css_heresHowYouKnowButton).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1431 Verify, for the "eBusiness Solutions" logo text hyperlink, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.topNav.css_eBusinessSolutions).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1432 Verify, for the "eInsurance" navigational menu item button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eInsurance).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1433 Verify, for the "ePharmacy" navigational menu item button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eInsurance).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1434 Verify, for the "eBilling" navigational menu item button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eBilling).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1435 Verify, for the "ePayments" navigational menu item button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_ePayments).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1436 Verify, for the "Non-MCCF" navigational menu item button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_nonMCCF).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1437 Verify, for the "NPI" navigational menu item button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_npi).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1438 Verify, for the "eAdmin" navigational menu item button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eAdmin).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1440 Verify, for the "Search" submit button, the value inside each ARIA attribute is spelled correctly and corresponds to a valid value.', function() {
    expect( pages.menuNav.searchButton.isDisplayed() ).toBe(true);
    AxeBuilder(browser).include(pages.menuNav.css_searchButton).withRules('aria-valid-attr-value').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1471a Check the "News/Announcements" section to ensure content embodied in heading elements do not contain text that is hidden.', function() {
    // split up as right now there are no list items
    AxeBuilder(browser).include(pages.home.css_news_header).withRules('empty-heading').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC1471b Check the "News/Announcements" section to ensure content embodied in heading elements do not contain text that is hidden.', function() {
    AxeBuilder(browser).include(pages.home.css_news_items).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC1472a Check the "Alerts/Updates" section to ensure that the header elements <h1> through <h6> does not contain any hidden text.', function() {
    AxeBuilder(browser).include(pages.home.css_alerts_items).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1472b Check the "Alerts/Updates" section to ensure that the header elements <h1> through <h6> does not contain any hidden text.', function() {
    AxeBuilder(browser).include(pages.home.css_alerts_header).withRules('empty-heading').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  // Currently no items in list
  xit('TC1473 Check the "Contact List" section to ensure content embodied in heading elements do not contain text that is hidden.', function() {
    AxeBuilder(browser).include(pages.home.css_contacts_items).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1473b Check the "Contact List" section to ensure content embodied in heading elements do not contain text that is hidden.', function() {
    AxeBuilder(browser).include(pages.home.css_contacts_header).withRules('empty-heading').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1474 Check the "eBusiness Solutions" text in the footer to ensure content embodied in heading elements do not contain text that is hidden.', function() {
    AxeBuilder(browser).include(pages.footer.css_eBusinessSolutions_header).withRules('empty-heading').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1476 Check the date/timestamp in the footer to ensure content embodied in heading elements do not contain text that is hidden.', function() {
    AxeBuilder(browser).include(pages.footer.css_dateTime).analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); // note* hidden elements would fail this check
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1524 For all text used in hyperlinks, buttons, and links, none of it can be repeated in the image alternative.', function() {
    AxeBuilder(browser).include('a').withRules('image-redundant-alt').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
    AxeBuilder(browser).include('img').withRules('image-redundant-alt').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1534 <ul> and <ol> must only directly contain <li> content elements.', function() {
    AxeBuilder(browser).withRules('list').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1535 Every <li> element in the page must be contained in a <ul> or a <ol> element.', function() {
    AxeBuilder(browser).withRules('list').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });





});
