//us2211.compliance.e2e.ts
import 'jasmine';
import {browser, by} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';
var AxeBuilder = require('axe-webdriverjs');
var pages = new Pages();
var helpers = new Helpers();

describe('US2211 (Copy of) 508.01.02.07 Web Application Table Headers (1194.22G)', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });

  // AXE

  it('TC1418 Verify the document\'s header tag\'s (i.e., <header>) ARIA role contains all required child roles.', function() {
    AxeBuilder(browser).include('header').withRules('aria-required-children').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1520 Ensure summary and caption text(s) are different from each other.', function() {
    AxeBuilder(browser).withRules('table-duplicate-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1521 All cells in a <table> element that use the headers attribute must only refer to other cells of that same table', function() {
    AxeBuilder(browser).withRules('td-headers-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1522 All <th> elements and elements with role=columnheader/rowheader must have data cells they describe.', function() {
    AxeBuilder(browser).withRules('th-has-data-cells').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

});