//us1409.e2e.ts
import 'jasmine';
import {browser, by} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';

var pages = new Pages();
var helpers = new Helpers();

describe('US1409 Product Landing Page - eBilling, eInsurance, ePayments, ePharmacy, eAdmin, Non MCCF', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });

  xit('TC1194 Validate Product Landing Page Consitent Look and Feel - eBilling', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    verifyLookAndFeel();
  });

  xit('TC1195 Validate Product Landing Page Consitent Look and Feel - eInsurance', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    verifyLookAndFeel();
  });

  xit('TC1196 Validate Product Landing Page Consitent Look and Feel - ePayments', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    verifyLookAndFeel();
  });

  xit('TC1197 Validate Product Landing Page Consitent Look and Feel - ePharmacy', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    verifyLookAndFeel();
  });

  xit('TC1198 Validate Product Landing Page Consistent Look and Feel - eAdmin', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    verifyLookAndFeel();
  });

  xit('TC1199 Validate Product Landing Page Consitent Look and Feel - Non MCCF', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
    verifyLookAndFeel();
  });

  it('TC1591 Validate Product Landing Page Consitent Look and Feel - NPI', function() {
    pages.menuNav.npi.click();
    expect(pages.npi.welcome.isDisplayed()).toBe(true);
    pages.breadcrumbs.breadcrumb.getText().then(function(value) {
      expect(value).toEqual('MCCF EDI TAS Portal Home Page NPI');
    });
    verifyLookAndFeel();
  });

  it('TC1200 Validate Product Landing Page Consitent Look and Feel - eBilling', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    pages.breadcrumbs.breadcrumb.getText().then(function(value) {
      expect(value).toEqual('MCCF EDI TAS Portal Home Page eBilling');
    });
    verifyLookAndFeel();
  });

  it('TC1201 Validate Standard Functionality on Product Landing Page - eInsurance', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    pages.breadcrumbs.breadcrumb.getText().then(function(value) {
      expect(value).toEqual('MCCF EDI TAS Portal Home Page eInsurance');
    });
    verifyLookAndFeel();
  });

  it('TC1202 Validate Standard Functionality on Product Landing Page - ePayments', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    pages.breadcrumbs.breadcrumb.getText().then(function(value) {
      expect(value).toEqual('MCCF EDI TAS Portal Home Page ePayments');
    });
    verifyLookAndFeel();
  });

  it('TC1203 Validate Standard Functionality on Product Landing Page - ePharmacy', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    pages.breadcrumbs.breadcrumb.getText().then(function(value) {
      expect(value).toEqual('MCCF EDI TAS Portal Home Page ePharmacy');
    });
    verifyLookAndFeel();
  });

  it('TC1204 Validate Standard Functionality on Product Landing Page - eAdmin', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    pages.breadcrumbs.breadcrumb.getText().then(function(value) {
      expect(value).toEqual('MCCF EDI TAS Portal Home Page eAdmin');
    });
    verifyLookAndFeel();
  });

  it('TC1205 Validate Standard Functionality on Product Landing Page - Non MCCF', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
    pages.breadcrumbs.breadcrumb.getText().then(function(value) {
      expect(value).toEqual('MCCF EDI TAS Portal Home Page Non-MCCF');
    });
    verifyLookAndFeel();
  });





  function verifyLookAndFeel(){
    // Logo
    expect(pages.topNav.logo.isDisplayed()).toBe(true);

    // Header
    expect(pages.topNav.eBusinessSolutions.isDisplayed()).toBe(true);
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.topNav.help.isDisplayed()).toBe(true);
    expect(pages.topNav.eRevenueResource.isDisplayed()).toBe(true);

    // Menu
    expect(pages.menuNav.searchButton.isDisplayed()).toBe(true);
    expect(pages.menuNav.searchInput.isDisplayed()).toBe(true);
    expect(pages.menuNav.eBilling.isDisplayed()).toBe(true);
    expect(pages.menuNav.ePharmacy.isDisplayed()).toBe(true);
    expect(pages.menuNav.eInsurance.isDisplayed()).toBe(true);
    expect(pages.menuNav.ePayments.isDisplayed()).toBe(true);
    expect(pages.menuNav.eAdmin.isDisplayed()).toBe(true);
    expect(pages.menuNav.nonMCCF.isDisplayed()).toBe(true);
    expect(pages.menuNav.npi.isDisplayed()).toBe(true);
    

    // Footer
    expect(pages.footer.eBusinessSolutions.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
    
    // Contact Us Link
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
    // Help
    expect(pages.footer.help.isDisplayed()).toBe(true);
    expect(pages.footer.phoneNumber.isDisplayed()).toBe(true);
    expect(pages.footer.email.isDisplayed()).toBe(true);
    
    // Current Date/Time
    expect(pages.footer.dateTime.isDisplayed()).toBe(true);

  };

});