//us1406.e2e.ts
import 'jasmine';
import {browser, by} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';

var pages = new Pages();
var helpers = new Helpers();

describe('US1406 Define Layout of the MCCF EDI home Page', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });


  it('TC1477 Verify the "Index" page (i.e., index.html) directs the user to the correct URL.', function() {
    let baseURL = browser.getCurrentUrl();
    browser.get('index.html');
    expect(browser.getCurrentUrl()).toEqual(baseURL);
  });


  it('TC1231 Validate User can Access the eBilling Product Page from the MCCF EDI TAS Portal home Page via Navigation Bar', function() {
    expect(browser.isElementPresent(pages.eBilling.welcome)).toBe(false);
    pages.menuNav.eBilling.click();

    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.eBilling.welcome)).toBe(false);
    helpers.sizeToStandardMobile();

    pages.menuNav.gotoMenuEBilling();

    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.eBilling.welcome)).toBe(false);

  });

  it('TC1232 Validate User can Access the ePharmacy Product Page from the MCCF EDI TAS Portal home Page via Navigation Bar', function() {
    expect(browser.isElementPresent(pages.ePharmacy.welcome)).toBe(false);
    pages.menuNav.ePharmacy.click();

    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.ePharmacy.welcome)).toBe(false);

    helpers.sizeToStandardMobile();

    pages.menuNav.gotoMenuEPharmacy();

    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.ePharmacy.welcome)).toBe(false);

  });

  it('TC1233 Validate User can Access the eInsurance Product Page from the MCCF EDI TAS Portal home Page via Navigation Bar', function() {
    pages.menuNav.eInsurance.click();

    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.eInsurance.welcome)).toBe(false);
    helpers.sizeToStandardMobile();

    pages.menuNav.gotoMenuEInsurance();

    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.eInsurance.welcome)).toBe(false);

  });

  it('TC1234 Validate User can Access the ePayments Product Page from the MCCF EDI TAS Portal home Page via Navigation Bar', function() {
    pages.menuNav.ePayments.click();

    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.ePayments.welcome)).toBe(false);
    helpers.sizeToStandardMobile();

    pages.menuNav.gotoMenuEPayments();

    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.ePayments.welcome)).toBe(false);

  });

  it('TC1235 Validate User can Access the eAdmin Product Page from the MCCF EDI TAS Portal home Page via Navigation Bar', function() {
    pages.menuNav.eAdmin.click();

    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.eAdmin.welcome)).toBe(false);
    helpers.sizeToStandardMobile();

    pages.menuNav.gotoMenuEAdmin();

    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    pages.home.get();
    expect(browser.isElementPresent(pages.eAdmin.welcome)).toBe(false);

  });

  it('TC1501 Verify User Can Access MCCF EDI TAS Portal via URL', function() {
    expect(browser.isElementPresent(pages.topNav.eBusinessSolutions)).toBe(true);
  });

  it('TC1502 Validate the eBilling Page Contains a Contact Us Link', function() {
    pages.menuNav.eBilling.click();
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
  });

  it('TC1503 Validate the eInsurance Page Contains a Contact Us Link', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
  });

  it('TC1504 Validate the ePharmacy Page Contains a Contact Us Link', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
  });

  it('TC1505 Validate the ePayments Page Contains a Contact Us Link', function() {
    pages.menuNav.ePayments.click();
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
  });

  it('TC1506 Validate the eAdmin Page Contains a Contact Us Link', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
  });

  it('TC1507 Validate the Non MCCF Page Contains a Contact Us Link', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
  });

  it('TC1508 Validate the NPI Page Contains a Contact Us Link', function() {
    pages.menuNav.npi.click();
    expect(pages.topNav.contactUs.isDisplayed()).toBe(true);
    expect(pages.footer.contactUs.isDisplayed()).toBe(true);
  });

  it('TC1509 Validate the Non MCCF Page Contains a Contact Us Link', function() {
    pages.menuNav.nonMCCF.click();
    expect(browser.isElementPresent(pages.topNav.contactUs)).toBe(true);
    pages.topNav.contactUs.click();
    expect(browser.isElementPresent(pages.contactUs.welcome)).toBe(true);
  });

  it('TC1510 Validate the NPI Page Contains a Contact Us Link', function() {
    pages.menuNav.npi.click();
    expect(browser.isElementPresent(pages.topNav.contactUs)).toBe(true);
    pages.topNav.contactUs.click();
    expect(browser.isElementPresent(pages.contactUs.welcome)).toBe(true);
  });

  it('TC1511 Validate the eBilling Page Contains a FAQ Link', function() {
    pages.menuNav.eBilling.click();
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
  });

  it('TC1512 Validate the eInsurance Page Contains a FAQ Link', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
  });

  it('TC1513 Validate the ePayments Page Contains a FAQ Link', function() {
    pages.menuNav.ePayments.click();
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
  });

  it('TC1514 Validate the ePharmacy Page Contains a FAQ Link', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
  });

  it('TC1515 Validate the eAdmin Page Contains a FAQ Link', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
  });

  it('TC1516 Validate the Non MCCF Page Contains a FAQ Link', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
  });

  it('TC1517 Validate the NPI Page Contains a FAQ Link', function() {
    pages.menuNav.npi.click();
    expect(pages.topNav.faq.isDisplayed()).toBe(true);
    expect(pages.footer.faq.isDisplayed()).toBe(true);
  });

  it('TC1539 Test for the "eInsurance" Product Page Sub Menu Item verifying URL address redirects the user to the correct Product Page.', function() {
    expect(browser.isElementPresent(pages.eInsurance.welcome)).toBe(false);
    browser.get('einsurance/home');
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
  });

  it('TC1540 Test the "ePharmacy" Product Page Sub Menu Item hyperlink redirects the user to the "ePharmacy" Product Page when selected.', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
  });
  
  it('TC1542 Test the "eBilling" Product Page Sub Menu Item hyperlink redirects the user to the "eBilling" Product Page when selected.', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
  });

  it('TC1541 Test for the "ePharmacy" Product Page Sub Menu Item verifying URL address redirects the user to the correct Product Page.', function() {
    expect(browser.isElementPresent(pages.ePharmacy.welcome)).toBe(false);
    browser.get('epharmacy/home');
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
  });

  it('TC1543 Verify when entering manually the "eBilling" Product Page URL address does redirect the user to the correct Product Page.', function() {
    expect(browser.isElementPresent(pages.eBilling.welcome)).toBe(false);
    browser.get('ebilling/home');
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
  });

  it('TC1545 Verify that entering ePayments URL can be accessed directly', function() {
    expect(browser.isElementPresent(pages.ePayments.welcome)).toBe(false);
    browser.get('epayments/home');
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
  });

  it('TC1547 Verify when manually entering "Non-MCCF" Product Page URL address does redirect the user to the correct Product Page.', function() {
    expect(browser.isElementPresent(pages.nonMCCF.welcome)).toBe(false);
    browser.get('non-mccf/home');
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
  });

  it('TC1549 Verify when entering the "NPI" Product Page URL address manually, does redirect the user to the correct Product Page.', function() {
    expect(browser.isElementPresent(pages.npi.welcome)).toBe(false);
    browser.get('npi/home');
    expect(pages.npi.welcome.isDisplayed()).toBe(true);
  });

  it('TC1550 Test the "eAdmin" Product Page Sub Menu Item hyperlink redirects the user to the "eAdmin" Product Page when selected.', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
  });

  it('TC1551 Verify when the "eAdmin" Product Page URL address does redirect the user to the correct Product Page when entered manually.', function() {
    expect(browser.isElementPresent(pages.eAdmin.welcome)).toBe(false);
    browser.get('eadmin/home');
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
  });

  it('TC1554 Selecting the "FAQ" hyperlink in the header redirects the user to the "Under Construction" page when selected.', function() {
    pages.topNav.faq.click();
    expect(browser.isElementPresent(pages.faq.underConstruction)).toBe(true);
  });

  it('TC1154 Validate Access to Product Pages via Navigation Bar', function() {
    expect(pages.menuNav.eInsurance.isDisplayed()).toBe(true);
    expect(pages.menuNav.ePharmacy.isDisplayed()).toBe(true);
    expect(pages.menuNav.eBilling.isDisplayed()).toBe(true);
    expect(pages.menuNav.ePayments.isDisplayed()).toBe(true);
    expect(pages.menuNav.nonMCCF.isDisplayed()).toBe(true);
    expect(pages.menuNav.npi.isDisplayed()).toBe(true);
    expect(pages.menuNav.eAdmin.isDisplayed()).toBe(true);
  });

  it('TC1560 Selecting the "eBusiness Solutions" logo text hyperlink in the header redirects the user to the "MCCF EDI TAS Portal Index Page" when selected.', function() {
    pages.menuNav.eBilling.click();
    pages.topNav.eBusinessSolutions.click();
    expect(pages.home.calendarContainer.isDisplayed()).toBe(true);
  });

  it('TC1562 The "MCCF EDI TAS Portal Index Page" will contain a Title Bar (with graphic).', function() {
    expect(pages.topNav.logo.isDisplayed()).toBe(true);
    expect(pages.topNav.eBusinessSolutions.isDisplayed()).toBe(true);
  });

  it('TC1263 Validate MCCF EDI Home Page contains a Section (Container) for eBilling Product', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.container.isDisplayed()).toBe(true);
  });

  it('TC1264 Validate MCCF EDI Home Page contains a Section (Container) for eInsurance Product', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.container.isDisplayed()).toBe(true);
  });

  it('TC1265 Validate MCCF EDI Home Page contains a Section (Container) for ePayments Product', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.container.isDisplayed()).toBe(true);
  });

  it('TC1266 Validate MCCF EDI Home Page contains a Section (Container) for ePharmacy Product', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.container.isDisplayed()).toBe(true);
  });

  it('TC1267 Validate MCCF EDI Home Page contains a Section (Container) for eAdmin Product', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.container.isDisplayed()).toBe(true);
  });

  it('TC1277 Validate the MCCF EDI Home Page Contains a Contact Us Link', function() {
    pages.topNav.contactUs.click();
    expect(pages.contactUs.container.isDisplayed()).toBe(true);
    expect(pages.contactUs.welcome.isDisplayed()).toBe(true);
    expect(pages.contactUs.underConstruction.isDisplayed()).toBe(true);
  });

  it('TC1278 Validate the MCCF EDI Home Page Contains a FAQ Link', function() {
    pages.topNav.faq.click();
    expect(pages.faq.container.isDisplayed()).toBe(true);
    expect(pages.faq.welcome.isDisplayed()).toBe(true);
    expect(pages.faq.underConstruction.isDisplayed()).toBe(true);
  });

  it('TC1279 Validate the MCCF EDI Home Page Displays a Calendar', function() {
    expect(pages.home.calendarContainer.isDisplayed()).toBe(true);
  });

  it('TC1592 The "MCCF EDI TAS Portal Index Page" will contain a Title Bar (with graphic).', function() {
    expect(browser.isElementPresent(pages.topNav.logo)).toBe(true);
  });

  it('TC1645 Verify that the date/time in the footer reflects the current time to match the users system', function() {
    pages.footer.dateTime.getText().then( function(value) {
      var date = new Date();
      var dateShown = new Date(value);
      var timeDifference = Math.abs(date.getTime() - dateShown.getTime());
      expect(timeDifference).toBeLessThan(2000); // 2 second tolerance fast or slow
    });
  });

  it('TC1546 Test the "Non-MCCF" Product Page Sub Menu Item hyperlink redirects the user to the "Non-MCCF" Product Page when selected.', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
  });

  it('TC1555 Selecting the "FAQ" hyperlink in the footer redirects the user to the "Under Construction" page when selected.', function() {
    pages.footer.faq.click();
    expect(pages.faq.underConstruction.isDisplayed()).toBe(true);
  });

  it('TC1556 Selecting the "Contact Us" hyperlink in the header redirects the user to the "Under Construction" page when selected.', function() {
    pages.topNav.contactUs.click();
    expect(pages.contactUs.underConstruction.isDisplayed()).toBe(true);
  });

  it('TC1544 Test the "ePayments" Product Page Sub Menu Item hyperlink redirects the user to the "ePayments" Product Page when selected.', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
  });

  



});
