//us1406.compliance.e2e.ts
import 'jasmine';
import {browser, by, element, protractor} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';
var AxeBuilder = require('axe-webdriverjs');
var pages = new Pages();
var helpers = new Helpers();

describe('US1406 Define Layout of the MCCF EDI home Page', function() {

  beforeAll(function() {
    browser.driver.getCapabilities().then(function(caps){
      browser.browserName = caps.get('browserName');
    });
  });

  beforeEach(function() {
    helpers.sizeToStandardDesktop();
    pages.home.get();
  });

  // AXE

  it('TC1401 Verify the "Here\'s how you know" button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.usaBanner.css_heresHowYouKnowButton).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1402 Verify that the "eBusiness Solutions" logo text hyperlink allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.topNav.css_eBusinessSolutions).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1403 Verify the "eInsurance" navigational menu item button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eInsurance).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1404 Verify the "ePharmacy" navigational menu item button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_ePharmacy).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1405 Verify the "eBilling" navigational menu item button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eBilling).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1406 Verify the "ePayments" navigational menu item button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_ePayments).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1407 Verify the "Non-MCCF" navigational menu item button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_nonMCCF).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1408 Verify the "NPI" navigational menu item button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_npi).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1409 Verify the "eAdmin" navigational menu item button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eAdmin).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1411 Verify the "Site-wide Search" submit button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_searchButton).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1414 Verify the document\'s header tag\'s (i.e., <header>) ARIA roles have all required ARIA attributes.', function() {
    AxeBuilder(browser).include('header').withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1415 Verify the document\'s nav tag\'s (i.e., <nav>) ARIA roles have all required ARIA attributes.', function() {
    AxeBuilder(browser).include('nav').withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1416 Verify the document\'s div _ngcontent-c2 element\'s (i.e., <div _ngcontent-c2>) ARIA roles have all required ARIA attributes.', function() {
    AxeBuilder(browser).include('div').withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1417 Verify the document\'s footer tag\'s (i.e., <footer>) ARIA roles have all required ARIA attributes.', function() {
    AxeBuilder(browser).include('footer').withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1422 Verify the document\'s header tag\'s (i.e., <header>) ARIA role is contained by all required parent roles.', function() {
    AxeBuilder(browser).include('header').withRules('aria-required-parent').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1423 Verify the document\'s nav tag\'s (i.e., <nav>) ARIA role is contained by all required parent roles.', function() {
    AxeBuilder(browser).include('nav').withRules('aria-required-parent').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1424 Verify the document\'s div _ngcontent-c2 element\'s (i.e., <div _ngcontent-c2>) ARIA role is contained by all required parent roles.', function() {
    AxeBuilder(browser).include('div').withRules('aria-required-parent').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1425 Verify the document\'s footer tag\'s (i.e., <footer>) ARIA role is contained by all required parent roles.', function() {
    AxeBuilder(browser).include('footer').withRules('aria-required-parent').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  

  it('TC1442 Ensure the "Here\'s how you know" button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.usaBanner.css_heresHowYouKnowButton).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1443 Ensure the "eBusiness Solutions" logo text hyperlink\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.topNav.css_eBusinessSolutions).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1444 Ensure the "eInsurance" navigational menu item button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eInsurance).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1445 Ensure the "ePharmacy" navigational menu item button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_ePharmacy).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1446 Ensure the "eBilling" navigational menu item button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eBilling).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1447 Ensure the "ePayments" navigational menu item button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_ePayments).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1448 Ensure the "Non-MCCF" navigational menu item button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_nonMCCF).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1450 Ensure the "NPI" navigational menu item button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_npi).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1451 Ensure the "eAdmin" navigational menu item button\'s ARIA attributes conform to valid names.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eAdmin).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1453 Ensure the "Search" submit button\'s ARIA attributes conform to valid names.', function() {
    expect( pages.menuNav.searchButton.isDisplayed() ).toBe(true);
    AxeBuilder(browser).include(pages.menuNav.css_searchButton).withRules('aria-valid-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  // DE421
  xit('TC1469 Text elements must have sufficient color contrast against the background.', function() {
    expect(element( by.css('body') ).isDisplayed()).toBe(true);
    element( by.css('body') ).sendKeys(protractor.Key.TAB);
    //browser.executeScript('document.getElementsByClassName("usa-skipnav")[0].focus();').then(function(value){
    //browser.driver.sleep(1000);
    AxeBuilder(browser).exclude(pages.topNav.css_search).withRules('color-contrast').analyze(function(results) {
          // phantomjs sendkeys and focus not working
      if (browser.browserName === 'phantomjs') {
        expect(results.incomplete.length).toEqual(1);
      } else {
        expect(results.incomplete.length).toEqual(0);
      };
      expect(results.violations.length).toEqual(0);
          // expect(results.passes.length).toEqual(1);
    });
    //});
    pages.topNav.search.click();
    expect( pages.topNav.searchButton.isDisplayed() ).toBe(true);
    AxeBuilder(browser).include(pages.topNav.css_searchButton).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      // console.log(results.incomplete[0].nodes);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1519 Elements should not have tabindex greater than zero.', function() {
    AxeBuilder(browser).withRules('tabindex').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1523 Every id attribute value must be unique.', function() {
    AxeBuilder(browser).withRules('duplicate-id').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1398 HTML document root must have a valid ISO 639-1 language code value for the lang attribute.', function() {
    expect(browser.findElement(by.tagName('html')).getAttribute('lang')).toEqual('en');
  });

  it('TC1399 Verify the the document\'s html tag (i.e., <html>) has a valid lang attribute.', function() {
    expect(browser.findElement(by.tagName('html')).getAttribute('lang')).toEqual('en');
  });

  it('TC1412 Verify the "Contact Search" submit button allows an ARIA attribute for the element\'s role tag.', function() {
    AxeBuilder(browser).include(pages.home.css_contactsSearch_button).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      //expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1482 should allow the user to scale up to 200%.', function() {
    browser.findElement(by.css('meta[name=\'viewport\']')).getAttribute('content').then( function(value) {
        expect(value.match('maximum-scale=([0-9]*)')[1]).toBeGreaterThanOrEqual(2);
      });
  });

  it('TC1518 Zooming and scaling must not be disabled (2x).', function() {
    browser.findElement(by.css('meta[name=\'viewport\']')).getAttribute('content').then( function(value) {
        expect ( value.includes('user-scalable=no') ).toBe(false);
      });
  });


});
