//menunav.po.ts
import {browser, by, element} from 'protractor';
import 'jasmine';

export class MenuNav {
  // css
  css_eInsurance = 'nav[role=\'navigation\'] a[href=\'/einsurance/home\'] span';
  css_ePharmacy = 'nav[role=\'navigation\'] a[href=\'/epharmacy/home\'] span';
  css_eBilling = 'nav[role=\'navigation\'] a[href=\'/ebilling/home\'] span';
  css_ePayments = 'nav[role=\'navigation\'] a[href=\'/epayments/home\'] span';
  css_eAdmin = 'nav[role=\'navigation\'] a[href=\'/eadmin/home\'] span';
  css_nonMCCF = 'nav[role=\'navigation\'] a[href=\'/non-mccf/home\'] span';
  css_npi = 'nav[role=\'navigation\'] a[href=\'/npi/home\'] span';
  css_searchButton = 'nav[role=\'navigation\'] form.usa-search button';
  css_searchInput = 'nav[role=\'navigation\'] div#mySearch input#search-field-smallsite-wide-search';

  // standard view
  eBilling = element( by.css(this.css_eBilling) );
  ePharmacy = element( by.css(this.css_ePharmacy) );
  eInsurance = element( by.css(this.css_eInsurance) );
  ePayments = element( by.css(this.css_ePayments) );
  eAdmin = element( by.css(this.css_eAdmin) );
  nonMCCF = element( by.css(this.css_nonMCCF) );
  npi = element( by.css(this.css_npi) );

  // menu
  menu = element( by.css('button.usa-menu-btn') );
  menuSearchBox = element( by.css('input[type=\'search\']') );
  menuSearchButton = element( by.css(this.css_searchButton) );
  menuFAQ = element( by.xpath('a.usa-nav-link[href=\'/common/faq\']') );
  menuContactUs = element( by.css('a[href=\'/common/contact\']') );
  menuHelp = element( by.css('a[href=\'/common/help\']') );
  menuERevenueResource = element( by.css('app-link[title=\'VA eRevenue Website\'] > a') );
  menuClose = element(by.css('button.usa-nav-close') );
  menuEBilling = element( by.css('a.usa-nav-link[href=\'/ebilling/home\'] span') );
  menuEPharmacy = element( by.css('a.usa-nav-link[href=\'/epharmacy/home\'] span') );
  menuEInsurance = element( by.css('a.usa-nav-link[href=\'/einsurance/home\'] span') );
  menuEPayments = element( by.css('a.usa-nav-link[href=\'/epayments/home\'] span') );
  menuEAdmin = element( by.css('a.usa-nav-link[href=\'/eadmin/home\'] span') );
  menuNonMCCF = element( by.css('a.usa-nav-link[href=\'/non-mccf/home\'] span') );
  menuNPI = element( by.css('a.usa-nav-link[href=\'npi/home\'] span') );

  searchInput = element( by.css(this.css_searchInput) );
  searchButton = element( by.css(this.css_searchButton) );

  menuAnimationPause(){
    browser.driver.sleep(1000);
  }

  openMenu(){
    this.menu.click();
    this.menuAnimationPause();
  }

  gotoMenuEBilling(){
    this.openMenu();
    this.menuEBilling.click();
  }

  gotoMenuEPharmacy(){
    this.openMenu();
    this.menuEPharmacy.click();
  }

  gotoMenuEInsurance(){
    this.openMenu();
    this.menuEInsurance.click();
  }

  gotoMenuEPayments(){
    this.openMenu();
    this.menuEPayments.click();
  }

  gotoMenuEAdmin(){
    this.openMenu();
    this.menuEAdmin.click();
  }


  verifyAllMenuItemsPresent(){
    expect(this.menuEBilling.isDisplayed()).toBe(true);
    expect(this.menuEPharmacy.isDisplayed()).toBe(true);
    expect(this.menuEInsurance.isDisplayed()).toBe(true);
    expect(this.menuEPayments.isDisplayed()).toBe(true);
    expect(this.menuEAdmin.isDisplayed()).toBe(true);
    expect(this.menuNonMCCF.isDisplayed()).toBe(true);
    expect(this.menuNPI.isDisplayed()).toBe(true);
    expect(this.menuClose.isDisplayed()).toBe(true);
    expect(this.menuHelp.isDisplayed()).toBe(true);
    expect(this.menuContactUs.isDisplayed()).toBe(true);
    expect(this.menuFAQ.isDisplayed()).toBe(true);
    expect(this.menuERevenueResource.isDisplayed()).toBe(true);
    expect(this.menuSearchBox.isDisplayed()).toBe(true);
    expect(this.menuSearchButton.isDisplayed()).toBe(true); // looks like a chrome bug, need to try better version when possible
  }

};