//junitreporter.js
module.exports = function(options) {

  this.jasmineStarted = function() {
    this.testCount = 0;
    this.failCount = 0; 
    this.testSuites = [];
    this.testSuitesStartTime = new Date();
  };

  this.jasmineDone = function() {
    this.testSuitesEndTime = new Date();
    this.testSuitesTime = (this.testSuitesEndTime - this.testSuitesStartTime)/1000;
    this.writeLog();
  };

  this.suiteStarted = function(result) {
    let newsuite = {};
    newsuite.tests = [];
    newsuite.name = this.cleanName(result.description);
    newsuite.id = result.id;
    newsuite.testCount = 0;
    newsuite.failCount = 0;
    newsuite.suiteStartTime = new Date();
    this.testSuites.push(newsuite);
  },

  this.suiteDone = function(result) {
    let suite = this.testSuites[this.testSuites.findIndex(x => x.id === result.id)];
    suite.suiteEndTime = new Date();
    suite.time = (suite.suiteEndTime - suite.suiteStartTime)/1000;
    this.testSuites[this.testSuites.findIndex(x => x.id === result.id)] = suite;
  },

  this.specStarted = function(result) {
    if (result.status != 'pending') {
      let testSuiteName = result.fullName.substring(0,(result.fullName.indexOf(result.description)-1));
      testSuiteName = this.cleanName(testSuiteName);
      let suite = this.testSuites[this.testSuites.findIndex(x => x.name === testSuiteName)];
      let newtest = {};
      newtest.startTime = new Date();
      newtest.id = result.id;
      suite.tests.push(newtest);
      this.testSuites[this.testSuites.findIndex(x => x.name === testSuiteName)] = suite;
    }
  };

  this.specDone = function(result) {
    if (result.status != 'pending') {
      let testSuiteName = result.fullName.substring(0,result.fullName.indexOf(result.description)-1);
      testSuiteName = this.cleanName(testSuiteName);
      let suite = this.testSuites[this.testSuites.findIndex(x => x.name === testSuiteName)];
      let test = suite.tests[suite.tests.findIndex(x => x.id === result.id)];
      test.endTime = new Date();
      test.time = (test.endTime - test.startTime) / 1000;
      test.description = this.cleanName(result.description);
      test.failures = [];
      if (result.status == 'failed') {
        suite.failCount++;
        this.failCount++;
        result.failedExpectations.forEach( function (f){
          let fail = {};
          fail.message = f.message;
          fail.stack = f.stack;
          test.failures.push(fail);
        });
      };
      suite.testCount++;
      this.testCount++;
      suite.tests[suite.tests.findIndex(x => x.id === result.id)] = test;
      this.testSuites[this.testSuites.findIndex(x => x.name === testSuiteName)] = suite;
    }
  };

  this.cleanName = function(name) {
    return name.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;");
  }

  this.writeLog = function() {
    var fs = require('fs');

    try {
      fs.mkdirSync(options.savePath)
    } catch (e) {
      if (e.code == 'EEXIST') {}
      else {
        throw(e);
      }
    };


    logText = '<?xml version="1.0" encoding="UTF-8" ?>\n';
    logText += '<testsuites\n';
    logText += ' tests="' + this.testCount + '"';
    logText += ' failures="' + this.failCount + '"';
    logText += ' time="' + this.testSuitesTime + '"';
    logText += '>\n';
    this.testSuites.forEach( function (s){
      logText += '<testsuite';
      logText += ' name="' + s.name + '"';
      logText += ' tests="' + s.testCount + '"';
      logText += ' failures="' + s.failCount + '"';
      logText += ' time="' + s.time + '"';
      logText += '>\n';
      s.tests.forEach( function (t){
        if ( typeof t.description !== 'undefined'){
          logText += '<testcase';
          logText += ' name="';
          logText += t.description;
          logText += '"';
          logText += ' time="';
          logText += t.time;
          logText += '"';
          logText += '>\n';
          t.failures.forEach( function (f){
            logText += '<failure';
            logText += ' message="';
            logText += f.message;
            logText += '"';
            logText += '>\n';
            logText += f.stack;
            logText += '\n</failure>\n';
          });
          logText += '</testcase>\n';
        };
      });
      logText += '</testsuite>\n';
    });
    logText += '</testsuites>';
    fs.writeFile((options.savePath + "/" + options.saveFilename), logText, function (err) {
      if (err) return console.log(err);
    });
  };

/*
      

      


*/
};