//pages.ts
import {EBusinessSolutionsHome} from '../pages/home.po';
import {EBilling} from '../pages/ebilling.po';
import {EPharmacy} from '../pages/epharmacy.po';
import {EInsurance} from '../pages/einsurance.po';
import {EPayments} from '../pages/epayments.po';
import {EAdmin} from '../pages/eadmin.po';
import {NonMCCF} from '../pages/nonmccf.po';
import {NPI} from '../pages/npi.po';
import {Help} from '../pages/help.po';
import {ICBWeb} from '../pages/icbweb.po';
import {FAQ} from '../pages/faq.po';
import {ContactUs} from '../pages/contactus.po';

import {USABanner} from '../pages/partials/usabanner.po';
import {TopNav} from '../pages/partials/topnav.po';
import {MenuNav} from '../pages/partials/menunav.po';
import {Breadcrumbs} from '../pages/partials/breadcrumbs.po';
import {Footer} from '../pages/partials/footer.po';
import {ResourceWarning} from '../pages/partials/resourcewarning.po';


export class Pages {
    // Partials
    usaBanner;
    topNav;
    menuNav;
    breadcrumbs;
    footer;
    resourceWarning;

    // Pages
    home;
    eBilling;
    ePharmacy;
    eInsurance;
    ePayments;
    eAdmin;
    nonMCCF;
    npi;
    help;
    iCBWeb;
    contactUs;
    faq;

    constructor () {
      this.usaBanner = new USABanner();
      this.topNav = new TopNav();
      this.menuNav = new MenuNav();
      this.breadcrumbs = new Breadcrumbs();
      this.footer = new Footer();
      this.resourceWarning = new ResourceWarning();

      this.home = new EBusinessSolutionsHome();
      this.eBilling = new EBilling();
      this.ePharmacy = new EPharmacy();
      this.eInsurance = new EInsurance();
      this.ePayments = new EPayments();
      this.eAdmin = new EAdmin();
      this.nonMCCF = new NonMCCF();
      this.npi = new NPI();
      this.help = new Help();
      this.iCBWeb = new ICBWeb();
      this.contactUs = new ContactUs();
      this.faq = new FAQ();
    }

};