import {Injectable} from '@angular/core';
import {Headers, Http, Response} from '@angular/http';
import {Observable} from 'rxjs/Rx';
import {IamRecord} from "../iam-manager/iam-record"

@Injectable()
export class IamRecordService {
  private _iamReecords: Observable<any>
  private headers = new Headers({'X-UserId': 'user01', 'X-Key': '12345'})
  private iamRecordGUID
  private coreAPI
  private IAM_RECORDS_URL = '../../assets/config/mock-iam-records.json'

  constructor(private http: Http) {
    console.log('IamRecord Service cTor')
  }

  public clearCache(): any {
    // super.clearCache();
    this._iamReecords = null;
  }

  public getIamRecords(): Observable<IamRecord[]> {
    return this._getIamRecord()
  }

  private _getIamRecord(): Observable<IamRecord[]> {
    if (!this._iamReecords) {
      // TODO use iam database
      let url = (false) ? `http://localhost:8193/api/v1/iamrecords` : this.IAM_RECORDS_URL
      // let url = (environment.enable_api) ? `${service.coreAPI}/iamrecords` : this.IAM_RECORDS_URL
      this._iamReecords =
        this.http.get(url, {headers: this.headers})
          .map((res) => this.mapIamRecord(res))
          .publishReplay(1)
          .refCount()
          .catch((err, caught) => this.handleError(err))
    }
    return this._iamReecords;
  }

  public setIamRecord(iamRecords: IamRecord[]) {
    return this._setIamRecord(iamRecords)
  }

  private _setIamRecord(iamRecords: IamRecord[]): Observable<boolean> {

    return this.http.put(`http://localhost:8193/api/v1/iamRecords/${this.iamRecordGUID}`, iamRecords, {headers: this.headers})
      .map(response => {
        console.log(response)
        return response.text()
      })
      .catch(this.handleError)
  }

  private mapIamRecord(response: Response): IamRecord[] {
    // TODO we are using the first menu item, will need to map user.group.menu.id
    let items = response.json().items;
    // this.iamRecordGUID = item0.id;
    return items
  }

  // private toIamRecord(r: any): IamRecord {
  //   debugger
  //   const menu = <IamRecord>({
  //     title: r.title,
  //     uri: r.uri,
  //     subIamRecord: r.subIamRecord
  //   });
  //   return menu;
  // }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }
}
