import { ModuleWithProviders } from '@angular/core'
import { Routes, RouterModule } from '@angular/router'
import { AdminMenusComponent } from './admin-menus/admin-menus.component'
import { MainContentComponent } from './main-content/main-content.component'
import { AdminHomeComponent } from './admin-home/admin-home.component'
import { IamManagerComponent } from './iam-manager/iam-manager.component'
import { AdminHelpComponent } from './admin-help/admin-help.component'

const routes: Routes = [
  { path: 'home',
    component: AdminHomeComponent,
    data: { breadcrumb: "Admin Home"}
  },
  { path: 'adminhelp/:prod',
    component: AdminHelpComponent,
    data: { breadcrumb: "Edit Help"}
  },
  { path: 'menus',
    component: AdminMenusComponent,
    data: { breadcrumb: "Edit TAS Menus"}
  },
  { path: 'iam-manager',
    component: IamManagerComponent,
    data: { breadcrumb: "IAM User/Role Management"}
  },
  { path: 'maincontent',
    component: MainContentComponent,
    data: { breadcrumb: "Edit Main Content"}
  }
]

export const routing: ModuleWithProviders = RouterModule.forChild(routes);
