import { NgModule, ModuleWithProviders } from '@angular/core'
import { CommonModule } from '@angular/common'
import { routing } from './mccf-system.routing'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import { MccfCommonModule } from '../mccf-common/mccf-common.module'
import { EditorModule,
          DataTableModule,
          SharedModule
        } from 'primeng/primeng'

import { AdminMenusComponent } from './admin-menus/admin-menus.component'
import { MainContentComponent } from './main-content/main-content.component';
import { AdminHomeComponent } from './admin-home/admin-home.component';
import { IamManagerComponent } from './iam-manager/iam-manager.component'
import { AdminHelpComponent } from './admin-help/admin-help.component'


@NgModule({
  imports: [
    CommonModule,
    FormsModule,
    routing,
    ReactiveFormsModule,
    EditorModule,
    DataTableModule,
    SharedModule,
    MccfCommonModule
  ],
  declarations: [
    AdminMenusComponent,
    MainContentComponent,
    AdminHomeComponent,
    IamManagerComponent,
    AdminHelpComponent
  ]
})
export class MccfSystemModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: CommonModule
    }
  }
}
