import {Component, OnInit, ChangeDetectorRef} from '@angular/core'

import {MainContent} from '../../core/maincontent/maincontent'
import {MainContentService} from '../../core/maincontent/maincontent.service'
import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {MccfFormComponent} from '../../mccf-common/mccf-form/mccf-form.component'
import {ErrorService} from '../../core/error-messages/error.service'
import {Subscription} from "rxjs/Subscription";
import {Product} from '../../core/maincontent/product'
import {BreadcrumbService} from '../../core/breadcrumb/breadcrumb.service'
import {EnvironmentService} from '../../core/env/environment.service'

@Component({
  selector: 'app-main-content',
  templateUrl: './main-content.component.html',
  styleUrls: ['./main-content.component.css']
})

export class MainContentComponent extends MccfFormComponent implements OnInit {
  mainContent: MainContent

  // angular can not detect changes in arrays
  // so flatten product urls for updating view
  homeProd: Product
  ebillingProd: Product
  einsuranceProd: Product
  epharmacyProd: Product
  epaymentsProd: Product
  npiProd: Product
  nonmccfProd: Product

  isChanged = false
  private subscription: Subscription
  private updateSubscription: Subscription

  constructor(private ttService: TooltipsService,
              private error: ErrorService,
              private mcService: MainContentService,
              public breadcrumbService: BreadcrumbService,
              private ref: ChangeDetectorRef,
              private env: EnvironmentService) {
    super(ttService, error, env)
  }

  ngOnInit() {
    super.ngOnInit()
    this.load()
  }

  load() {
    this.mcService.getContent()
      .subscribe(
        res => {
          this.mainContentUpdate(res)
        },
        err => {
          this.error.setErrorCode("", err)
        })
  }

  mainContentUpdate(data: MainContent) {
    this.mainContent = new MainContent()
    this.mainContent.phone = data.phone
    this.mainContent.emailText = data.emailText
    this.mainContent.emailValue = data.emailValue

    // angular can not detect changes in arrays
    // so flatten product urls for updating view
    this.homeProd = this.json2Product(data.product
      .filter((p: Product) => p.name === 'home')[0])
    this.ebillingProd = this.json2Product(data.product
      .filter((p: Product) => p.name === 'eBilling')[0])
    this.einsuranceProd = this.json2Product(data.product
      .filter((p: Product) => p.name === 'eInsurance')[0])
    this.epharmacyProd = this.json2Product(data.product
      .filter((p: Product) => p.name === 'ePharmacy')[0])
    this.epaymentsProd = this.json2Product(data.product
      .filter((p: Product) => p.name === 'ePayments')[0])
    this.npiProd = this.json2Product(data.product
      .filter((p: Product) => p.name === 'NPI')[0])
    this.nonmccfProd = this.json2Product(data.product
      .filter((p: Product) => p.name === 'Non-MCCF')[0])

    this.isChanged = false
  }

  cancel() {
    this.mainContent = null
    this.ngOnInit()
  }

  onChange(e: any) {
    this.isChanged = true
  }

  save() {
    this.mainContent.product = []
    this.mainContent.product.push(this.homeProd)
    this.mainContent.product.push(this.ebillingProd)
    this.mainContent.product.push(this.einsuranceProd)
    this.mainContent.product.push(this.epharmacyProd)
    this.mainContent.product.push(this.epaymentsProd)
    this.mainContent.product.push(this.npiProd)
    this.mainContent.product.push(this.nonmccfProd)

    this.updateSubscription = this.mcService.saveContent(this.mainContent).subscribe(
      res => {
        this.mainContent = null
        alert(" no database")
        this.ngOnInit()
      },
      err => {
        this.error.setErrorCode("", err)
      })
  }

  json2Product(data: any): Product {
    let p = new Product()

    if (data === undefined) {
      console.error(" undefined Product")
      return p
    }

    p.name = data["name"]
    p.erevenueUrl = data["erevenueUrl"]
    return p
  }

}
