import { async,
    ComponentFixture,
    TestBed,
    fakeAsync,
    getTestBed,
    tick
    } from '@angular/core/testing'
import { HttpModule} from '@angular/http'
import {MccfCommonModule} from '../../mccf-common/mccf-common.module'
import { EditorModule } from 'primeng/primeng'
import * as Axe from 'axe-core'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import {RouterTestingModule} from '@angular/router/testing'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { MainContentComponent } from './main-content.component'
import { MainContent } from '../../core/maincontent/maincontent'
import { Product } from '../../core/maincontent/product'
import {ConfigService} from '../../core/config/config.service'
import {Renderer} from '@angular/core'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import {EnvironmentService} from '../../core/env/environment.service'
import {TooltipsService} from "../../mccf-common/tooltips/tooltips.service"
import {ErrorService} from "../../core/error-messages/error.service"

describe('MainContentComponent', () => {
  let component: MainContentComponent
  let fixture: ComponentFixture<MainContentComponent>

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
              HttpModule,
              EditorModule,
              FormsModule,
              MccfCommonModule,
              ReactiveFormsModule,
              RouterTestingModule.withRoutes([])
            ],
      declarations: [MainContentComponent],
      providers: [
              MainContentService,
              ConfigService,
              Renderer,
              BreadcrumbService,
              EnvironmentService,
              MainContentService,
              TooltipsService,
              ErrorService
            ]
    }).compileComponents()

  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(MainContentComponent)
    component = fixture.componentInstance
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  })

  it('should have no accessibility issues', fakeAsync(() => {
    let mc = new MainContent()
    mc.phone = "555-5555"
    mc.emailText = "veEmail"
    mc.emailValue = "email321987@va.com"

    let ebill = new Product()
    ebill.name = "eBilling"
    ebill.erevenueUrl = "www.erev.com"
    mc.product.push(ebill)

    let einsurance = new Product()
    einsurance.name = "eInsurance"
    einsurance.erevenueUrl = "www.erev.com/homesite/2/page"
    mc.product.push(einsurance)

    let home = new Product()
    home.name = "home"
    home.erevenueUrl = "www.erevhome.com"
    mc.product.push(home)

    let npi = new Product()
    npi.name = "NPI"
    npi.erevenueUrl = "www.erev.com/npi/pages/2"
    mc.product.push(npi)

    let ePharmacy = new Product()
    ePharmacy.name = "ePharmacy"
    ePharmacy.erevenueUrl = "www.erev.com/epharm/32/home"
    mc.product.push(ePharmacy)

    let ePayments = new Product()
    ePayments.name = "ePayments"
    ePayments.erevenueUrl = "www.erev.com/epay/32/home"
    mc.product.push(ePayments)

    let nonmccfProd = new Product()
    nonmccfProd.name = "Non-MCCF"
    nonmccfProd.erevenueUrl = "www.Non-MCCF.com"
    mc.product.push(nonmccfProd)

    component.mainContentUpdate(mc)
    tick(10)
    fixture.detectChanges()
    // console.error(' @@@@@@@@@@@@@@@@@@@@@@@@@@ html=' + document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  it('should show product data', fakeAsync(() => {
    let mc = new MainContent()
    mc.phone = "555-5555"
    mc.emailText = "veEmail"
    mc.emailValue = "email321987@va.com"

    let ebill = new Product()
    ebill.name = "eBilling"
    ebill.erevenueUrl = "www.erev.com"
    mc.product.push(ebill)

    let einsurance = new Product()
    einsurance.name = "eInsurance"
    einsurance.erevenueUrl = "www.erev.com/homesite/2/page"
    mc.product.push(einsurance)

    let home = new Product()
    home.name = "home"
    home.erevenueUrl = "www.erevhome.com"
    mc.product.push(home)

    let npi = new Product()
    npi.name = "NPI"
    npi.erevenueUrl = "www.erev.com/npi/pages/2"
    mc.product.push(npi)

    let ePharmacy = new Product()
    ePharmacy.name = "ePharmacy"
    ePharmacy.erevenueUrl = "www.erev.com/epharm/32/home"
    mc.product.push(ePharmacy)

    let ePayments = new Product()
    ePayments.name = "ePayments"
    ePayments.erevenueUrl = "www.erev.com/epay/32/home"
    mc.product.push(ePayments)

    let nonmccfProd = new Product()
    nonmccfProd.name = "Non-MCCF"
    nonmccfProd.erevenueUrl = "www.Non-MCCF.com"
    mc.product.push(nonmccfProd)

    component.mainContentUpdate(mc)
    tick(10)
    fixture.detectChanges()

    expect(component.mainContent.phone).toEqual("555-5555")
    expect(component.homeProd.name).toEqual("home")
    expect(component.ebillingProd.name).toEqual("eBilling")
    expect(component.einsuranceProd.name).toEqual("eInsurance")
    expect(component.epharmacyProd.name).toEqual("ePharmacy")
    expect(component.npiProd.name).toEqual("NPI")
    expect(component.nonmccfProd.name).toEqual("Non-MCCF")
    expect(component.epaymentsProd.name).toEqual("ePayments")
    expect(component.homeProd.erevenueUrl).toEqual("www.erevhome.com")

  }))

})
