import {Component, OnDestroy, OnInit} from '@angular/core'
import {Iam} from './iam'
import {IamRecord} from './iam-record'
import {IamPermission} from './iam-permission'
import {PermissionsService} from '../service/permissions.service'
import {Subscription} from "rxjs/Subscription"
import {IamRecordService} from "../service/iam.service"
import {ErrorService} from "../../core/error-messages/error.service"
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'
import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {EnvironmentService} from '../../core/env/environment.service'


@Component({
  selector: 'app-iam-manager',
  templateUrl: './iam-manager.component.html',
  styleUrls: ['./iam-manager.component.css'],
  providers: [PermissionsService, TooltipsService]
})
export class IamManagerComponent implements OnInit, OnDestroy {
  maincontentService: MainContentService
  product: Product
  iamRecord: IamRecord = new IamRecord()
  selectedIamRecord: IamRecord
  iamRecords: IamRecord[]
  iamPerms: IamPermission[]
  selectedIamPerms: IamPermission[]
  page = 'list'
  formInvalid = false
  private subscription: Subscription
  iamUrl: string

  constructor(private permsService: PermissionsService,
              private service: IamRecordService,
              private error: ErrorService,
              private breadcrumbService: BreadcrumbService,
              private ttService: TooltipsService,
              private env: EnvironmentService) {
  }

  ngOnInit() {
    // first get environment variables
    this.env.getEnv().subscribe(this.envUpdate.bind(this))

    this.subscription = this.service.getIamRecords().subscribe(
      res => {
        this.iamRecords = res;
      },
      err => {
        this.error.setErrorCode("", err)
      })
  }

  envUpdate(env: any) {
    this.iamUrl = env.iamPermissionsUrl
  }

  ngOnDestroy() {
    if (this.subscription) {
      this.subscription.unsubscribe()
    }
  }

  onSubmit() {
    this.iamRecord.permissions = this.selectedIamPerms
    this.formInvalid = true

    // TODO save to database
    console.warn(" @@@@@@@@@@ implement me")

  }

  delete(id: string) {
    console.log(" id========" + id)
    // let index = this.findSelectedRecordIndex()
    // this.iamRecords = this.iamRecords.filter((val, i) => i !== index)
    // this.iamRecord = null
  }

  async onRowSelect(event) {
    this.formInvalid = false
    this.page = 'detail'
    this.iamRecord = this.cloneIamRecord(event.data)
    this.selectedIamPerms = event.data.permissions
    this.permsService.getPermissions(this.iamUrl).subscribe((res) => {
      this.iamPerms = res
    })
  }

  cloneIamRecord(c: Iam): IamRecord {
    let rec = new IamRecord()
    for (const prop in c) {
      if (c.hasOwnProperty(prop)) {
        rec[prop] = c[prop]
      }
    }
    return rec
  }

  cancel() {
    this.iamRecord = null
    this.page = 'list'
  }

  findSelectedRecordIndex(): number {
    return this.iamRecords.indexOf(this.selectedIamRecord);
  }


}
