
import {async, ComponentFixture, fakeAsync, getTestBed, TestBed, tick} from '@angular/core/testing'
import * as Axe from 'axe-core'
import {Renderer} from '@angular/core'
import {FormsModule, ReactiveFormsModule} from '@angular/forms'
import {MccfCommonModule} from '../../mccf-common/mccf-common.module'
import {HttpModule} from '@angular/http'
import {KarmaHelper} from '../../../../karma/karma-helper'
import {RouterTestingModule} from '@angular/router/testing';
import {BreadcrumbService} from '../../core/breadcrumb/breadcrumb.service'
import {IamManagerComponent} from './iam-manager.component'
import {PermissionsService} from '../service/permissions.service'
import {IamRecordService} from "../service/iam.service"
import {ErrorService} from "../../core/error-messages/error.service"
import {EnvironmentService} from '../../core/env/environment.service'
import { ConfigService } from '../../core/config/config.service'
import { EditorModule,
          DataTableModule,
          SharedModule
        } from 'primeng/primeng'

describe('IamManagerComponent', () => {
  let component: IamManagerComponent
  let fixture: ComponentFixture<IamManagerComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        FormsModule,
        EditorModule,
        DataTableModule,
        SharedModule,
        MccfCommonModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        IamManagerComponent
      ],
      providers: [
        PermissionsService,
        IamRecordService,
        ErrorService,
        BreadcrumbService,
        EnvironmentService,
        ConfigService
      ]
    })

  }))

  beforeEach(() => {
    fixture = TestBed.createComponent(IamManagerComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('list page should have no accessibility issues', (() => {
    let res: Axe.AxeResults
    let el = fixture.nativeElement
    fixture.detectChanges()
    // console.error(' @@@@@@@@@@@@@@@@@@@@@@@@@@ html=' + el.innerHTML)

    expect(component.page).toEqual("list")

    it('should have no accessibility issues', ((done) => {
      Axe.run(el.innerHTML, KarmaHelper.axeOptions()).then((result) => {
        KarmaHelper.axeViolationLog(result)
        expect(result.violations.length).toEqual(0)
        done()
      }).catch((error) => {
          console.error("AXE-CORE ERROR:" + error)
      })
    }))

  }))

  it('detail page should have no accessibility issues', (() => {
    let res: Axe.AxeResults
    component.page = 'detail'
    fixture.detectChanges()

    expect(component.page).toEqual("detail")

    let el = fixture.nativeElement
    // console.error(' @@@@@@@@@@@@@@@@@@@@@@@@@@ html=' + el.innerHTML)

    it('should have no accessibility issues', ((done) => {
      Axe.run(el.innerHTML, KarmaHelper.axeOptions()).then((result) => {
        KarmaHelper.axeViolationLog(result)
        expect(result.violations.length).toEqual(0)
        done()
      }).catch((error) => {
          console.error("AXE-CORE ERROR:" + error)
      })
    }))

  }))

})
