import {Component, ElementRef,
        OnInit, QueryList, Renderer, ViewChildren} from '@angular/core'
import {Router} from '@angular/router'
import {Http} from '@angular/http'
import {MenusService} from '../../core/menus/menus.service'
import {Menu} from '../../core/menus/menu'
import {SubMenu} from '../../core/menus/subMenu'
import {ErrorService} from '../../core/error-messages/error.service'
import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {MccfFormComponent} from '../../mccf-common/mccf-form/mccf-form.component'
import {EnvironmentService} from '../../core/env/environment.service'
import {BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'

@Component({
  selector: 'app-admin-menus',
  templateUrl: './admin-menus.component.html',
  styleUrls: ['./admin-menu.component.css'],
  providers: [TooltipsService]
})
export class AdminMenusComponent extends MccfFormComponent implements OnInit {
  paths: string[]
  errorMessage = ''
  menus: Menu[]
  formInvalid = false
  isChanged = false
  @ViewChildren('menuTitle', {read: ElementRef}) menuTitles: QueryList<ElementRef>
  modulePaths: any[] = []

  constructor(private env: EnvironmentService,
              private menuService: MenusService,
              private error: ErrorService,
              private renderer: Renderer,
              private router: Router,
              private ttService: TooltipsService,
              private http: Http,
              private breadcrumbService: BreadcrumbService) {
    super(ttService, error, env)
  }

  ngOnInit() {
    super.ngOnInit()
    this.load()
  }

  load() {
    this.menuService.getMenus()
      .subscribe(
        res => {
          this.menuUpdate(res)
        },
        err => {
          this.error.setErrorCode("", err)
        })
  }

  save() {
    this.validate()

    if (!this.formInvalid) {
       alert(" no database.")
      // this.menuService.setMenus(this.menus).subscribe(
      //   res => {
      //     alert(" no database.")
      //   },
      //   err => {
      //     this.error.setErrorCode("", err)
      //   })
    }

  }

  cancel() {
    this.menuService.getMenus()
      .subscribe(this.menuUpdate.bind(this))
    this.isChanged = false
    this.formInvalid = false
  }

  onChange() {
    this.isChanged = true
    this.formInvalid = false
  }

  validate() {
    // validation: titles required, no duplicate title

    let sortedMenu = this.menus.slice().sort()
    for (let i = 0; i < this.menus.length - 1; i++) {
      if (sortedMenu[i + 1].title === sortedMenu[i].title) {
        this.formInvalid = true
        return
      }
    }

    // sub menus
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].subMenu) {
        let sortedSub = this.menus[i].subMenu.slice().sort()
        for (let j = 0; j < this.menus[i].subMenu.length - 1; j++) {
          if (sortedSub[j + 1].title === sortedSub[j].title) {
            this.formInvalid = true
            return
          }
        }
      }
    }

    for (let i = 0; i < this.menus.length; i++) {

      if (this.menus[i].title.trim() === '') {
        this.formInvalid = true
        return
      }

      if (this.menus[i].subMenu) {
        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title.trim() === '') {
            this.formInvalid = true
            return
          }
        }
      }
    }
  }

  menuUpdate(data: any) {
    this.menus = data
  }

  addSubMenu(menu: string) {
    this.onChange()
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu) {
        let sub = new SubMenu()

        if (this.menus[i].subMenu === undefined) {
          this.menus[i].subMenu = []
        }
        this.menus[i].subMenu.push(sub)
      }
    }
  }

  deleteSub(menu: Menu, sub: SubMenu) {
    this.onChange()
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {

        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title === sub.title) {
            this.menus[i].subMenu.splice(j, 1)

            if (this.menus[i].subMenu.length === 0) {
              this.menus[i].subMenu = undefined
              return
            }
          }
        }
      }
    }
  }

  deleteMenu(menu: Menu) {
    this.onChange()
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        this.menus.splice(i, 1)
        return
      }
    }
  }

  addMenu() {
    this.onChange()
    let menu = new Menu()
    menu.title = "file me in"
    menu.uri = "http://wwwexample.com"
    this.menus.push(menu);
    setTimeout(() => {
      this.renderer.invokeElementMethod(this.menuTitles.last.nativeElement, 'focus')
    }, 1)
  }

  upMenu(menu: Menu) {
    this.onChange()
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        if (i === 0) {
          return
        }
        let above = this.menus[i - 1]
        this.menus[i - 1] = this.menus[i]
        this.menus[i] = above
        return
      }
    }
  }

  downMenu(menu: Menu) {
    this.onChange()
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        if (i === this.menus.length - 1) {
          return
        }
        let below = this.menus[i + 1]
        this.menus[i + 1] = this.menus[i]
        this.menus[i] = below
        return
      }
    }
  }

  upSubMenu(menu: Menu, sub: SubMenu) {
    this.onChange()
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title === sub.title) {
            if (j === 0) {
              return
            }
            let above = this.menus[i].subMenu[j - 1]
            this.menus[i].subMenu[j - 1] = this.menus[i].subMenu[j]
            this.menus[i].subMenu[j] = above
            return
          }
        }
      }
    }
  }

  downSubMenu(menu: Menu, sub: SubMenu) {
    this.onChange()
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title === sub.title) {
            if (j === this.menus[i].subMenu.length - 1) {
              return
            }
            let below = this.menus[i].subMenu[j + 1]
            this.menus[i].subMenu[j + 1] = this.menus[i].subMenu[j]
            this.menus[i].subMenu[j] = below
            return
          }
        }
      }
    }
  }
}
