import {async, ComponentFixture, fakeAsync, getTestBed, TestBed, tick} from '@angular/core/testing'
import * as Axe from 'axe-core'
import {Renderer} from '@angular/core'
import {FormsModule, ReactiveFormsModule} from '@angular/forms'
import {MccfCommonModule} from '../../mccf-common/mccf-common.module'
import {HttpModule} from '@angular/http'
import {KarmaHelper} from '../../../../karma/karma-helper'
import {RouterTestingModule} from '@angular/router/testing';
import {BreadcrumbService} from '../../core/breadcrumb/breadcrumb.service'
import {AdminMenusComponent} from './admin-menus.component'
import {MenusService} from '../../core/menus/menus.service'
import {Menu} from '../../core/menus/menu'
import {SubMenu} from '../../core/menus/subMenu'
import {ErrorService} from '../../core/error-messages/error.service'
import {EnvironmentService} from '../../core/env/environment.service'
import { ConfigService } from '../../core/config/config.service'

describe('AdminMenusComponent', () => {
  let component: AdminMenusComponent
  let fixture: ComponentFixture<AdminMenusComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        FormsModule,
        MccfCommonModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        AdminMenusComponent
      ],
      providers: [
        MenusService,
        ErrorService,
        Renderer,
        BreadcrumbService,
        EnvironmentService,
        ConfigService
      ]
    })

  }))

  beforeEach(async(() => {
    TestBed.compileComponents()
  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(AdminMenusComponent)
    component = fixture.componentInstance
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    component.menus = []

    let m = new Menu()
    m.title = 'menu title'
    m.uri = 'home'
    let sm = new SubMenu()
    sm.title = 'sub title'
    sm.uri = 'morehome'
    m.subMenu = []
    m.subMenu.push(sm)
    component.menus.push(m)

    let m2 = new Menu()
    m2.title = 'menu title2'
    m2.uri = 'home2'
    component.menus.push(m2)

    // TODO question for Patrick or Doug, does this component have paths?
    component.paths = []
    component.paths.push('home')
    component.paths.push('test/test1')
    component.paths.push('test/test2')
    component.paths.push('adminpage')
    component.paths.push('helppage')

    fixture.detectChanges()
    tick()

    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  it('should manipulate menus', (done) => {
    let res: Axe.AxeResults
    component.menus = []

    let m = new Menu()
    m.title = 'title1'
    m.uri = 'home'

    m.subMenu = []

    let sm = new SubMenu()
    sm.title = 'sub title'
    sm.uri = 'morehome'
    m.subMenu.push(sm)
    let sm2 = new SubMenu()
    sm2.title = 'sub title2'
    sm2.uri = 'morehome2'
    m.subMenu.push(sm2)

    component.menus.push(m)

    let m2 = new Menu()
    m2.title = 'title2'
    m2.uri = 'home2'
    component.menus.push(m2)

    // TODO question for Patrick or Doug, does this component have paths?
    component.paths = []
    component.paths.push('home')
    component.paths.push('test/test1')
    component.paths.push('test/test2')
    component.paths.push('adminpage')
    component.paths.push('helppage')

    fixture.detectChanges()
    expect(component.menus.length).toEqual(2)

    component.validate()
    fixture.detectChanges()
    expect(component.formInvalid).toEqual(false)

    component.upMenu(m2)
    fixture.detectChanges()
    expect(component.menus[0].title).toEqual('title2')

    component.downMenu(m2)
    fixture.detectChanges()
    expect(component.menus[0].title).toEqual('title1')

    component.upSubMenu(m, sm2)
    fixture.detectChanges()
    expect(component.menus[0].subMenu[0].title).toEqual('sub title2')

    component.downSubMenu(m, sm2)
    fixture.detectChanges()
    expect(component.menus[0].subMenu[1].title).toEqual('sub title2')


    done()
  })

})
