import { Component, OnInit } from '@angular/core'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { Product } from '../../core/maincontent/product'
import { Router } from '@angular/router'
@Component({
  selector: 'app-admin-home',
  templateUrl: './admin-home.component.html',
  styleUrls: ['./admin-home.component.css']
})
export class AdminHomeComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(private mcService: MainContentService,
              private router: Router,
              private breadcrumbService: BreadcrumbService) {
      this.maincontentService = mcService
   }

  ngOnInit() {
    this.breadcrumbService.reset()
  }

  nav(uri: string) {
    this.router.navigate([uri])
  }

}
