import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  getTestBed,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule } from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'

import { AdminHomeComponent } from './admin-home.component'

import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { MccfCommonModule } from '../../mccf-common/mccf-common.module'
import { Product } from '../../core/maincontent/product'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { ConfigService } from '../../core/config/config.service'
import { LoggerService } from '../../core/logger/logger.service'
import { AppModule } from '../../app.module'
import {ErrorService} from "../../core/error-messages/error.service";
import { EnvironmentService } from '../../core/env/environment.service'

describe('AdminHomeComponent', () => {
  let component: AdminHomeComponent
  let fixture: ComponentFixture<AdminHomeComponent>
  let originalTimeout

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        MccfCommonModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        AdminHomeComponent
      ],
      providers: [
        BreadcrumbService,
        MainContentService,
        ConfigService,
        ErrorService,
        LoggerService,
        EnvironmentService
      ]
    }).compileComponents()

    fixture = getTestBed().createComponent(AdminHomeComponent)
    component = fixture.componentInstance

  }))

  afterEach(function() {
    TestBed.resetTestingModule();
  });

  it('should have no accessibility issues', ((done) => {
    fixture.detectChanges()
    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
      console.error('AXE-CORE ERROR:' + error)
    })
    done()
  }))

})
