import { Component, OnInit, Input } from '@angular/core'
import { ActivatedRoute, Params} from '@angular/router'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import {MainContent} from '../../core/maincontent/maincontent'
import {ErrorService} from '../../core/error-messages/error.service'

const PRODUCT_ENUM = {
  site: "Site-wide",
  npi : "NPI",
  ebilling: "eBilling",
  epharmacy: "ePharmacy",
  einsurance: "eInsurance",
  nonmccf: "Non-MCCF",
  epayment: "ePayments"
}

@Component({
  selector: 'app-admin-help',
  templateUrl: './admin-help.component.html'
})
export class AdminHelpComponent implements OnInit {
  helpContent = ''
  product = ''
  isChanged = false
  widgetReady = false

  constructor(private mcService: MainContentService,
              private error: ErrorService,
              private activatedRoute: ActivatedRoute) { }

  ngOnInit() {
    this.product = PRODUCT_ENUM[this.activatedRoute.snapshot.paramMap.get('prod')]
    this.load(this.product.toLowerCase())
  }

  load(prod: string) {
    this.mcService.getHelpContent(prod)
      .subscribe(
        res => {
          this.helpLoaded(res);
        },
        err => {
          this.error.setErrorCode("", err)
        })
  }

  save() {
    this.mcService.saveHelpContent(this.product, this.helpContent)
      .subscribe(
        res => {
          alert("saved!!!!!!!!!! res = " + res)
        },
        err => {
          this.error.setErrorCode("", err)
        })
  }

  cancel() {
    this.widgetReady = false
    this.isChanged = false
    this.load(this.product.toLowerCase())
  }

  onChange(newValue) {
    if (this.widgetReady) {
      this.isChanged = true
    }
  }

  helpLoaded(data: any) {
    this.helpContent = data[`${this.product.toLowerCase()}:help`]

    let _this = this
    setTimeout(function() {
      _this.makeAccessible()
    }, 200)

  }

  // clean up widget for 508 accessibility compliance
  makeAccessible() {
    // primeng's Quill editor had hidden form element that we need to remove.
    let editorHiddenDiv = document.body.getElementsByClassName("ql-tooltip ql-hidden")
    if (editorHiddenDiv[0]) {
      editorHiddenDiv[0].parentNode.removeChild(editorHiddenDiv[0])
    }
    this.widgetReady = true
  }

}
