import {async, ComponentFixture, fakeAsync, getTestBed, TestBed, tick} from '@angular/core/testing'
import * as Axe from 'axe-core'
import {Renderer} from '@angular/core'
import {FormsModule, ReactiveFormsModule} from '@angular/forms'
import {HttpModule} from '@angular/http'
import {EditorModule} from 'primeng/primeng'
import {KarmaHelper} from '../../../../karma/karma-helper'
import {MccfCommonModule} from '../../mccf-common/mccf-common.module'
import {RouterTestingModule} from '@angular/router/testing'
import {BreadcrumbService} from '../../core/breadcrumb/breadcrumb.service'
import {AdminHelpComponent} from './admin-help.component'
import {MainContentService} from '../../core/maincontent/maincontent.service'
import {ErrorService} from '../../core/error-messages/error.service'
import {EnvironmentService} from '../../core/env/environment.service'
import {ConfigService} from '../../core/config/config.service'

describe('AdminHelpComponent', () => {
  let comp: AdminHelpComponent
  let fixture: ComponentFixture<AdminHelpComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        FormsModule,
        MccfCommonModule,
        EditorModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        AdminHelpComponent
      ],
      providers: [
        ErrorService,
        Renderer,
        BreadcrumbService,
        EnvironmentService,
        MainContentService,
        ConfigService
      ]
    }).compileComponents()

  }))

  beforeEach(async() => {
    fixture = getTestBed().createComponent(AdminHelpComponent)
    comp = fixture.componentInstance
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  })

  it('should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults

    comp.helpContent = "test my test <p>test</p>"
    comp.product = "eBilling"
    comp.makeAccessible()
    tick(20)

    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick(1)
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)
    tick(1)
    // getting error 'Error during cleanup of component', but unit test completes so ignore
  }))


})
