import { Component, OnInit } from '@angular/core';
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'

@Component({
  selector: 'app-npi-home',
  templateUrl: './npi-home.component.html',
  styleUrls: ['./npi-home.component.css']
})
export class NpiHomeComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(public breadcrumbService: BreadcrumbService,
          private mcService: MainContentService) { }

  ngOnInit() {
    this.breadcrumbService.reset()
    this.mcService.getProduct('NPI').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
