import { Component, OnInit } from '@angular/core'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { Product } from '../../core/maincontent/product'

@Component({
  selector: 'app-epharmacy-home',
  templateUrl: './epharmacy-home.component.html',
  styleUrls: ['./epharmacy-home.component.css']
})
export class EpharmacyHomeComponent implements OnInit {
  product: Product

  constructor(private breadcrumbService: BreadcrumbService,
              private mcService: MainContentService) { }

  ngOnInit() {
    this.breadcrumbService.reset()
    this.mcService.getProduct('ePharmacy').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
