import { ModuleWithProviders } from '@angular/core'
import { Routes, RouterModule } from '@angular/router'
import { EpaymentHomeComponent } from './epayment-home/epayment-home.component'
import { ErevenueReportComponent } from './erevenue-report/erevenue-report.component'
import { ErevenueStatusComponent } from './erevenue-status/erevenue-status.component'
import { CarcReportComponent } from './carc-report/carc-report.component'

const routes: Routes = [
  { path: 'home',
    component: EpaymentHomeComponent,
    data: { breadcrumb: "ePayments" }
  },
  { path: 'erevreport',
    component: ErevenueReportComponent,
    data: { breadcrumb: "Electronic Revenue Report" }
  },
  { path: 'erevstatus',
    component: ErevenueStatusComponent,
    data: { breadcrumb: "Electronic Revenue Status" }
  },
  { path: 'carcreport',
    component: CarcReportComponent,
    data: { breadcrumb: "CARC/RARC Report" }
  }
]

export const routing: ModuleWithProviders = RouterModule.forChild(routes)
