import {ModuleWithProviders, NgModule} from '@angular/core'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import { CommonModule } from '@angular/common'
import { MccfCommonModule } from '../mccf-common/mccf-common.module'
import { routing } from './mccf-epayment.routing'
import { EpaymentHomeComponent } from './epayment-home/epayment-home.component'
import { ErevenueReportComponent } from './erevenue-report/erevenue-report.component'
import { ErevenueStatusComponent } from './erevenue-status/erevenue-status.component'
import { CarcReportComponent } from './carc-report/carc-report.component'

@NgModule({
  imports: [CommonModule,
            routing,
            MccfCommonModule,
            FormsModule,
            ReactiveFormsModule
          ],
  declarations: [EpaymentHomeComponent,
                ErevenueReportComponent,
                ErevenueStatusComponent,
                CarcReportComponent
                ],
  exports: [EpaymentHomeComponent]
})
export class MccfEpaymentModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: EpaymentHomeComponent
    }
  }
}
