import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  getTestBed,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { MccfCommonModule } from '../../mccf-common/mccf-common.module'
import { HttpModule } from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'
import { ErevenueStatusComponent } from './erevenue-status.component';
import { ConfigService } from '../../core/config/config.service'
import { LoggerService } from '../../core/logger/logger.service'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { Product } from '../../core/maincontent/product'
import { ErrorService } from "../../core/error-messages/error.service"
import { EnvironmentService } from '../../core/env/environment.service'
import { ExtLinkService } from '../../core/ext-link/ext-link.service'

describe('EpaymentHomeComponent', () => {
  let component: ErevenueStatusComponent
  let fixture: ComponentFixture<ErevenueStatusComponent>
  let originalTimeout

  beforeEach(async(() => {
    originalTimeout = jasmine.DEFAULT_TIMEOUT_INTERVAL
    jasmine.DEFAULT_TIMEOUT_INTERVAL = 140000

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        MccfCommonModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        ErevenueStatusComponent
      ],
      providers: [BreadcrumbService,
        ConfigService,
        EnvironmentService,
        LoggerService,
        ErrorService,
        ExtLinkService
      ]
    })

  }))

  beforeEach(async(() => {
    TestBed.compileComponents()
  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(ErevenueStatusComponent)
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function() {
    jasmine.DEFAULT_TIMEOUT_INTERVAL = originalTimeout
    TestBed.resetTestingModule()
  });

  it('should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults

    fixture.detectChanges()
    tick()

    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))
})
