import { Component, OnInit } from '@angular/core';
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'

@Component({
  selector: 'app-epayment-home',
  templateUrl: './epayment-home.component.html',
  styleUrls: ['./epayment-home.component.css']
})

export class EpaymentHomeComponent implements OnInit {
  product: Product

  constructor(private breadcrumbService: BreadcrumbService,
          private mcService: MainContentService) { }

ngOnInit() {
  this.breadcrumbService.reset()
  this.mcService.getProduct('ePayments').subscribe(this.contentUpdate.bind(this))
}


  contentUpdate(prod: Product) {
    this.product = prod
  }

}
