import { Component, OnInit } from '@angular/core'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { Product } from '../../core/maincontent/product'

@Component({
  selector: 'app-einsurance-home',
  templateUrl: './einsurance-home.component.html',
  styleUrls: ['./einsurance-home.component.css']
})
export class EinsuranceHomeComponent implements OnInit {
  product: Product

  constructor(private mcService: MainContentService,
              private breadcrumbService: BreadcrumbService) { }

  ngOnInit() {
    this.breadcrumbService.reset()
    this.mcService.getProduct('eInsurance').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
