import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  getTestBed,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule } from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';
import { ExtLinkService } from '../../core/ext-link/ext-link.service'
import { EinsuranceHomeComponent } from './einsurance-home.component';
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { MccfCommonModule } from '../../mccf-common/mccf-common.module'
import { Product } from '../../core/maincontent/product'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { ConfigService } from '../../core/config/config.service'
import { LoggerService } from '../../core/logger/logger.service'
import { AppModule } from '../../app.module'
import {ErrorService} from "../../core/error-messages/error.service";
import { EnvironmentService } from '../../core/env/environment.service'

describe('EinsuranceHomeComponent', () => {
  let component: EinsuranceHomeComponent
  let fixture: ComponentFixture<EinsuranceHomeComponent>
  let originalTimeout

  beforeEach(async(() => {
    originalTimeout = jasmine.DEFAULT_TIMEOUT_INTERVAL
    jasmine.DEFAULT_TIMEOUT_INTERVAL = 140000

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        MccfCommonModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        EinsuranceHomeComponent
      ],
      providers: [
        BreadcrumbService,
        MainContentService,
        ConfigService,
        ErrorService,
        LoggerService,
        ExtLinkService,
        EnvironmentService
      ]
    })

  }))

  beforeEach(async(() => {
    TestBed.compileComponents()
  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(EinsuranceHomeComponent)
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function() {
    jasmine.DEFAULT_TIMEOUT_INTERVAL = originalTimeout
    TestBed.resetTestingModule();
  });

  it('div 1 should have no accessibility issues', ((done) => {
    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
      console.error('AXE-CORE ERROR:' + error)
    })
  }))

  it('div 2 should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults

    component.product = new Product()
    component.product.name = 'einsurance'
    component.product.erevenueUrl = 'www.duckduckgo.com'
    fixture.detectChanges()
    tick()

    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

})
