import { Component, OnInit } from '@angular/core';
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'

@Component({
  selector: 'app-ebilling-home',
  templateUrl: './eadmin.component.html'
})
export class EadminComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(private breadcrumbService: BreadcrumbService,
          private mcService: MainContentService) { }

  ngOnInit() {
    this.breadcrumbService.reset()
    this.mcService.getProduct('eBilling').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
