import { Injectable } from '@angular/core'
import { Headers, Http } from '@angular/http'
import { Observable } from 'rxjs/Rx'
import { ConfigService } from '../../core/config/config.service'

@Injectable()
export class TooltipsService {

  constructor(private configService: ConfigService) {
    console.log('ToolTipService cTor')
  }

  public clearCache(): any {
  }

  public getTooltips(): Observable<any> {
    return Observable.create(observer => {
      this.configService.load(["tooltips"])
        .subscribe(config => {
          observer.next(config.tooltips)
          observer.complete()
        })
    })
  }

  /**
   * slightly different usage here, this is a lookup from the client.
   * @param {Array<any>} tooltips
   * @param title
   * @returns {string}
   */
  public mapTooltips(tooltips: Array<any>, title): string {
    let tooltip = "Tooltip Not Found"

    if (tooltips.hasOwnProperty(title)) {
      tooltip = tooltips[title]
    }
    return tooltip
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }

}
