import {Component, OnInit} from '@angular/core'

import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {ErrorService} from "../../core/error-messages/error.service";
import {EnvironmentService} from '../../core/env/environment.service'

@Component({
  selector: 'app-mccf-form',
  templateUrl: './mccf-form.component.html',
  styleUrls: ['./mccf-form.component.css']
})
export class MccfFormComponent implements OnInit {
  private tooltips: Array<Object>

  constructor(private tooltipService: TooltipsService,
              private myError: ErrorService,
              private envr: EnvironmentService) {}

   ngOnInit() {
    // first get environment variables
    this.envr.getEnv().subscribe(this.formEnvUpdate.bind(this))
  }

  formEnvUpdate(env: any) {
    this.tooltipService.getTooltips()
                      .subscribe(this.toolsUpdate.bind(this))
    this.envUpdate(env)
  }

  envUpdate(env: any) {
    // override in child
  }

  toolsUpdate(tools: any) {
    this.tooltips = tools
  }

  tooltip(type: string, elem: any) {
    if (!elem.target.attributes['title']) {
      elem.target.setAttribute('title', '')
    }

    if (elem.target.attributes['title'].value === "") {
      elem.target.attributes['title'].value = this.tooltipService.mapTooltips(this.tooltips, type);
    }

  }

}
