import { ModuleWithProviders } from '@angular/core'
import { Routes, RouterModule } from '@angular/router'

import { SpellCheckComponent } from './spellcheck/spellcheck.component'
import { LoggerComponent } from './logger/logger.component'
import { FaqComponent } from './faq/faq.component'
import { HelpComponent } from './help/help.component'
import { ContactComponent } from './contact/contact.component'

const routes: Routes = [
  { path: 'logger',
    component: LoggerComponent
  },
  { path: 'spellcheck',
    component: SpellCheckComponent
  },
  { path: 'faq',
    component: FaqComponent,
    data: { breadcrumb: "FAQ"
  }
  },
  { path: 'help',
    component: HelpComponent,
    data: { breadcrumb: "Help"
  }
  },
  { path: 'contact',
    component: ContactComponent,
    data: { breadcrumb: "Contact Us" }
  }
];

export const routing: ModuleWithProviders = RouterModule.forChild(routes);
