import { NgModule, ModuleWithProviders } from '@angular/core';
import { CommonModule } from '@angular/common';

import {
  DataTableModule, EditorModule,
  SharedModule
} from 'primeng/primeng'

import { routing } from './mccf-common.routing'
import { RouterModule, Router } from '@angular/router'
import { SpellCheckComponent } from './spellcheck/spellcheck.component'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import { LoggerComponent } from './logger/logger.component'
import { LogTypePipe } from './logger/type.pipe'
import { FaqComponent } from './faq/faq.component'
import { HelpComponent } from './help/help.component'
import { ContactComponent } from './contact/contact.component'
import { MccfFormComponent } from './mccf-form/mccf-form.component'
import { BreadcrumbComponent } from './breadcrumb/breadcrumb.component'
import { ExtLinkComponent } from './ext-link/ext-link.component'

@NgModule({
  imports: [
    CommonModule,
    routing,
    FormsModule,
    ReactiveFormsModule,
    SharedModule,
    EditorModule,
    DataTableModule,
    ],
  declarations: [
    SpellCheckComponent,
    LoggerComponent,
    LogTypePipe,
    FaqComponent,
    HelpComponent,
    ContactComponent,
    MccfFormComponent,
    BreadcrumbComponent,
    ExtLinkComponent
  ],
  exports: [
    BreadcrumbComponent,
    ExtLinkComponent
  ]
})
export class MccfCommonModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: CommonModule
    }
  }
}
