import { Component, OnInit } from '@angular/core';
import { MainContent } from '../../core/maincontent/maincontent'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import {EnvironmentService} from '../../core/env/environment.service'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'

@Component({
  selector: 'app-help',
  templateUrl: './help.component.html',
  styleUrls: ['./help.component.css']
})
export class HelpComponent implements OnInit {
  mc: MainContent
  edit = false

  constructor(private mcService: MainContentService,
              private env: EnvironmentService,
              private breadcrumbService: BreadcrumbService) { }

  ngOnInit() {
    // first get environment variables
    this.env.getEnv().subscribe(this.envUpdate.bind(this))

    this.breadcrumbService.reset()
  }

  envUpdate(env: any) {
    this.mcService.getContent().subscribe(this.mainContentUpdate.bind(this))
  }

  mainContentUpdate(data: any) {
    this.mc = data
  }

  editMode() {
    this.edit = !this.edit
  }

}
